/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.stream.internal;

import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindListener;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IChangedListener;
import com.ti.backplane.bind.IDisposable;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStatus;
import com.ti.binding.stream.internal.AbstractFilesBind;
import com.ti.binding.stream.internal.IDebugFilter;
import com.ti.binding.stream.internal.PortBind;
import com.ti.binding.stream.internal.PortValue;
import com.ti.binding.stream.internal.StreamModel;
import com.ti.binding.stream.internal.StreamModelPlugin;
import java.util.ArrayList;

class PortsBind
extends AbstractFilesBind
implements IDisposable {
    IBindValue fBindNames;

    PortsBind(StreamModel model, IBindValue bindNames) {
        super(model, new ArrayList(), ArrayList.class);
        this.fBindNames = bindNames;
        this.fBindNames.addChangedListener(new IChangedListener(){

            public void onValueChanged(IFinished callback) {
                ArrayList newNames = (ArrayList)PortsBind.this.fBindNames.getValue();
                PortsBind.this.onNamesChanged(newNames, callback);
                if (callback != null) {
                    callback.done(null);
                }
            }
        });
        this.fBindNames.addBindListener(new IBindListener(){

            public void onStatusChanged(IStatus status) {
            }
        });
        ArrayList newNames = (ArrayList)this.fBindNames.getValue();
        this.onNamesChanged(newNames, null);
    }

    private void onNamesChanged(ArrayList<String> newNames, IFinished callback) {
        ArrayList oldValue = (ArrayList)this.getValue();
        ArrayList<PortValue> newValue = new ArrayList<PortValue>();
        boolean different = false;
        if (oldValue == null || oldValue.size() == 0) {
            if (newNames == null || newNames.size() == 0) {
                return;
            }
            for (String name : newNames) {
                newValue.add(new PortValue(this.getModel(), name));
            }
            different = true;
        } else if (newNames != null) {
            for (String name : newNames) {
                PortValue found = null;
                for (PortValue obj : oldValue) {
                    if (!obj.getName().equals(name)) continue;
                    found = obj;
                    break;
                }
                if (found != null) {
                    newValue.add(found);
                    continue;
                }
                newValue.add(new PortValue(this.getModel(), name));
                different = true;
            }
        }
        for (PortValue oldDC : oldValue) {
            if (newValue.contains(oldDC)) continue;
            different = true;
            oldDC.dispose();
        }
        if (different) {
            this.setValue(newValue, callback);
        }
    }

    @Override
    IBind createNewBind(String uri) {
        return new PortBind(this.getModel(), this, uri);
    }

    @Override
    public void dispose() {
        ArrayList ports;
        if (StreamModelPlugin.DEBUG) {
            StreamModelPlugin.debug("PortsBind.dispose()", IDebugFilter.LIFECYCLE);
        }
        if ((ports = (ArrayList)this.getValue()) != null) {
            for (PortValue v : ports) {
                v.dispose();
            }
        }
        ports.clear();
    }
}

