/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.stream.internal;

import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindProvider;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IDisposable;
import com.ti.binding.stream.internal.IDebugFilter;
import com.ti.binding.stream.internal.StreamBaseValueBind;
import com.ti.binding.stream.internal.StreamModel;
import com.ti.binding.stream.internal.StreamModelPlugin;
import java.util.HashMap;
import java.util.Map;

abstract class StreamBaseValueBindAndBindProvider
extends StreamBaseValueBind
implements IBindProvider {
    protected HashMap<String, IBind> fBinds = new HashMap();

    StreamBaseValueBindAndBindProvider(StreamModel model, Object initialValue, Class<?> defaultType) {
        super(model, initialValue, defaultType);
    }

    StreamBaseValueBindAndBindProvider(StreamModel model, Object initialValue) {
        super(model, initialValue);
    }

    StreamBaseValueBindAndBindProvider(StreamModel model) {
        super(model);
    }

    public IBind getBinding(String uri) {
        IBind bind = this.fBinds.get(uri);
        if (bind == null) {
            bind = this.createNewBind(uri);
            if (StreamModelPlugin.DEBUG) {
                StreamModelPlugin.debug(String.valueOf(this.getTraceName()) + ".createNewBind(" + uri + ")=" + bind, IDebugFilter.LIFECYCLE);
            }
            if (bind != null) {
                this.fBinds.put(uri, bind);
            }
        }
        if (StreamModelPlugin.DEBUG) {
            StreamModelPlugin.debug(String.valueOf(this.getTraceName()) + ".getBinding(" + uri + ")=" + bind, IDebugFilter.LIFECYCLE);
        }
        return bind;
    }

    public void dispose() {
        if (StreamModelPlugin.DEBUG) {
            StreamModelPlugin.debug(String.valueOf(this.getTraceName()) + ".dispose()", IDebugFilter.LIFECYCLE);
        }
        for (Map.Entry<String, IBind> entry : this.fBinds.entrySet()) {
            IBind bind = entry.getValue();
            if (!(bind instanceof IDisposable)) continue;
            ((IDisposable)bind).dispose();
        }
        this.fBinds.clear();
    }

    IBindValue getInternalBindFromMap(String variable) {
        IBind bind = this.fBinds.get(variable);
        if (bind instanceof IBindValue) {
            return (IBindValue)bind;
        }
        return null;
    }

    abstract IBind createNewBind(String var1);
}

