/*
 * Decompiled with CFR 0.152.
 */
package com.ti.binding.stream.internal;

import com.ti.backplane.bind.AbstractBindFactory;
import com.ti.backplane.bind.AbstractBindValue;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.internal.bind.DefaultBackplane;
import com.ti.binding.stream.internal.BaudActiveBind;
import com.ti.binding.stream.internal.BrowseFolder;
import com.ti.binding.stream.internal.BrowserAndLoad;
import com.ti.binding.stream.internal.BrowserAndSave;
import com.ti.binding.stream.internal.ComCommandBind;
import com.ti.binding.stream.internal.ComManager;
import com.ti.binding.stream.internal.FileNew;
import com.ti.binding.stream.internal.FileRead;
import com.ti.binding.stream.internal.FileWriteOrAppend;
import com.ti.binding.stream.internal.ListFiles;
import com.ti.binding.stream.internal.LoadAppData;
import com.ti.binding.stream.internal.PortActiveBind;
import com.ti.binding.stream.internal.PortBaseActiveBind;
import com.ti.binding.stream.internal.PortBaseNamesBind;
import com.ti.binding.stream.internal.PortNames;
import com.ti.binding.stream.internal.PortsBind;
import com.ti.binding.stream.internal.SaveAppData;
import java.util.ArrayList;
import java.util.Arrays;

public class StreamModel
extends AbstractBindFactory {
    static final String PORTS = "$ports";
    static final String PORTS_ACTIVE = "$ports.active";
    static final String PORTS_PATTERN = "$ports.match_pattern";
    static final String PORTS_BASE_NAMES = "$ports.base_names";
    static final String PORTS_BASE_ACTIVE = "$ports.base_active";
    static final String PORT = "port";
    static final String IN = "$in";
    static final String OPENED = "$opened";
    static final String BAUDS = "$bauds";
    static final String BAUDS_ACTIVE = "$bauds.active";
    static final int BAUDS_DEFAULT = 9600;
    static final String LOCAL_BROWSE_AND_LOAD = "$local_browse_and_load";
    static final String LOCAL_BROWSE_AND_SAVE = "$local_browse_and_save";
    static final String LOCAL_BROWSE_FOLDER = "$local_browse_folder";
    static final String LOCAL_FILE_WRITE = "$local_file_write";
    static final String LOCAL_FILE_READ = "$local_file_read";
    static final String REMOTE_FILE_READ = "$remote_file_read";
    static final String REMOTE_FILE_WRITE = "$remote_file_write";
    static final String REMOTE_FILE_NEW = "$remote_file_new";
    static final String LOCAL_LIST_FILES = "$local_list_files";
    static final String FILE = "file";
    static final String OUT = "$out";
    String[] baudNames = new String[]{"50", "75", "110", "134", "150", "300", "600", "1200", "1800", "2400", "4800", "7200", "9600", "14400", "19200", "28800", "38400", "56000", "57600", "115200", "128000", "153600", "230400", "256000", "460800", "921600"};
    ComManager commManager = new ComManager();

    protected IBind createNewBind(String uri) {
        if (uri.equals(PORT)) {
            IBindValue protNamesBind = (IBindValue)this.getBinding(PORTS);
            return new PortsBind(this, protNamesBind);
        }
        if (uri.equals("$send")) {
            return new ComCommandBind(this);
        }
        if (uri.equals(PORTS_PATTERN)) {
            return new AbstractBindValue((AbstractBindFactory)this, null, String.class);
        }
        if (uri.equals(PORTS_ACTIVE)) {
            return new PortActiveBind(this);
        }
        if (uri.equals(PORTS_BASE_ACTIVE)) {
            return new PortBaseActiveBind(this);
        }
        if (uri.equals(PORTS_BASE_NAMES)) {
            return new PortBaseNamesBind(this);
        }
        if (uri.equals(PORTS)) {
            return new PortNames(this);
        }
        if (uri.equals(BAUDS_ACTIVE)) {
            return new BaudActiveBind(this);
        }
        if (uri.equals(BAUDS)) {
            ArrayList<String> b = new ArrayList<String>(Arrays.asList(this.baudNames));
            return new AbstractBindValue((AbstractBindFactory)this, b);
        }
        if (uri.equals(LOCAL_BROWSE_AND_SAVE)) {
            return new BrowserAndSave(this);
        }
        if (uri.equals(LOCAL_BROWSE_AND_LOAD)) {
            return new BrowserAndLoad(this);
        }
        if (uri.equals(LOCAL_FILE_WRITE)) {
            return new FileWriteOrAppend(this, true);
        }
        if (uri.equals(LOCAL_FILE_READ)) {
            return new FileRead(this, true);
        }
        if (uri.equals(REMOTE_FILE_READ)) {
            return new FileRead(this, false);
        }
        if (uri.equals(REMOTE_FILE_WRITE)) {
            return new FileWriteOrAppend(this, false);
        }
        if (uri.equals(REMOTE_FILE_NEW)) {
            return new FileNew(this);
        }
        if (uri.equals(LOCAL_BROWSE_FOLDER)) {
            return new BrowseFolder(this);
        }
        if (uri.equals(LOCAL_LIST_FILES)) {
            return new ListFiles(this);
        }
        if (uri.equals("$save_app_data")) {
            return new SaveAppData(this);
        }
        if (uri.equals("$load_app_data")) {
            return new LoadAppData(this);
        }
        return null;
    }

    public DefaultBackplane getBackplane() {
        return (DefaultBackplane)this.fBackplane;
    }

    public String baseToDriverAssginedName(String baseName) {
        PortNames bind = (PortNames)this.getBinding(PORTS);
        return bind.BaseToDriverAssginedName(baseName);
    }

    public String driverAssginedToBaseName(String driverAssginedName) {
        PortNames bind = (PortNames)this.getBinding(PORTS);
        return bind.DriverAssginedToBaseName(driverAssginedName);
    }

    public int getActiveBaud() {
        int baud = 9600;
        Object value = ((IBindValue)this.getBinding(BAUDS_ACTIVE)).getValue();
        if (value instanceof String) {
            try {
                baud = Integer.parseInt((String)value);
            }
            catch (Exception exception) {}
        }
        return baud;
    }

    public ComManager getComManager() {
        return this.commManager;
    }
}

