/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.bind;

import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindListener;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.BackplanePlugin;
import com.ti.backplane.internal.IDebugFilter;
import java.util.HashSet;

public abstract class AbstractBind
implements IBind {
    private String fName;
    private HashSet<IBindListener> fBindListeners = new HashSet();
    private IStatus fStatus;

    @Override
    public void addBindListener(IBindListener listener) {
        if (this.fBindListeners.size() == 0) {
            this.onFirstBindListenerAdded();
        }
        this.fBindListeners.add(listener);
    }

    @Override
    public void removeBindListener(IBindListener listener) {
        this.fBindListeners.remove(listener);
        if (this.fBindListeners.size() == 0) {
            this.onLastBindListenerRemoved();
        }
    }

    protected void notifyStatusChanged(IStatus status) {
        for (IBindListener listener : this.fBindListeners) {
            listener.onStatusChanged(status);
        }
    }

    @Override
    public IStatus getStatus() {
        return this.fStatus;
    }

    @Override
    public void setStatus(IStatus status) {
        if (status == null && this.fStatus == null) {
            return;
        }
        if (status != null && status.equals(this.fStatus)) {
            return;
        }
        this.onStatusChanged(this.fStatus, status);
        this.fStatus = status;
        this.notifyStatusChanged(this.fStatus);
    }

    protected void onStatusChanged(IStatus oldStatus, IStatus newStatus) {
        if (BackplanePlugin.DEBUG) {
            BackplanePlugin.debug(String.valueOf(this.getTraceName()) + ".status=" + newStatus, IDebugFilter.STATUS_CHANGED);
        }
    }

    protected void onFirstBindListenerAdded() {
    }

    protected void onLastBindListenerRemoved() {
    }

    protected String getTraceName() {
        String className = this.getClass().toString();
        className = className.substring(className.lastIndexOf(46) + 1);
        return String.valueOf(className) + "[" + this.getName() + "]";
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }
}

