/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.bind;

import com.ti.backplane.bind.AbstractBindFactory;
import com.ti.backplane.bind.AbstractBindValue;
import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindAction;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IStatus;
import java.util.ArrayList;
import java.util.Map;

public abstract class AbstractBindAction
extends AbstractBindValue
implements IBindAction {
    public AbstractBindAction(AbstractBindFactory model) {
        this(model, true);
    }

    public AbstractBindAction(AbstractBindFactory model, boolean initialValue) {
        this(model, new Boolean(initialValue));
    }

    public AbstractBindAction(AbstractBindFactory model, Object initialValue) {
        super(model, initialValue);
    }

    public AbstractBindAction(AbstractBindFactory model, Object initialValue, Class<?> defaultType) {
        super(model, initialValue, defaultType);
    }

    protected <T> T getParameter(Object params, String name, Class<?> expectedType, IStatus[] retStatus) {
        Map map;
        if (params instanceof Map && (map = (Map)params).containsKey(name)) {
            Object obj = map.get(name);
            return this.castParamOrBind(obj, retStatus, expectedType, "Parameter " + name);
        }
        String paramURI = this.getBindForParameter(name);
        IBind bind = this.getModel().getBackplane().getBinding(paramURI);
        if (bind == null) {
            this.fillStatus(retStatus, "Bind " + paramURI + " does not exists");
            return null;
        }
        if (!(bind instanceof IBindValue)) {
            this.fillStatus(retStatus, "Bind " + paramURI + " is not IBindValue.");
            return null;
        }
        IBindValue bindValue = (IBindValue)bind;
        Object obj = bindValue.getValue();
        return this.castParamOrBind(obj, retStatus, expectedType, "Bind " + paramURI);
    }

    private <T> T castParamOrBind(Object obj, IStatus[] retStatus, Class<?> expectedType, String prefixMessage) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass().isAssignableFrom(expectedType)) {
            return (T)obj;
        }
        this.fillStatus(retStatus, String.valueOf(prefixMessage) + " is of unexpected type:" + obj.getClass());
        return null;
    }

    protected void fillStatus(IStatus[] retStatus, String message) {
        if (retStatus != null && retStatus.length > 0) {
            retStatus[0] = AbstractStatus.createErrorStatus(message);
        }
    }

    protected String getBindForParameter(String paramName) {
        return String.valueOf(this.getName()) + "." + paramName;
    }

    protected String[] toStringArray(ArrayList<?> arrayList) {
        ArrayList<String> stringArray = new ArrayList<String>();
        if (arrayList != null) {
            for (Object o : arrayList) {
                stringArray.add(o != null ? o.toString() : "");
            }
        }
        return stringArray.toArray(new String[0]);
    }
}

