/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.bind;

import com.ti.backplane.bind.AbstractBind;
import com.ti.backplane.bind.AbstractBindFactory;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IChangedListener;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IRealm;
import com.ti.backplane.bind.IStaleListener;
import com.ti.backplane.internal.BackplanePlugin;
import com.ti.backplane.internal.IDebugFilter;
import com.ti.backplane.internal.StaleBindImpl;
import com.ti.backplane.internal.bind.DefaultRealm;
import com.ti.backplane.internal.bind.FinishedCallback;
import java.util.ArrayList;

public class AbstractBindValue
extends AbstractBind
implements IBindValue {
    protected IChangedListener fHandler;
    protected ArrayList<IChangedListener> fHhandlers;
    protected Object fCachedValue;
    protected AbstractBindFactory fModel;
    private StaleBindImpl staleBindImpl;
    protected Class<?> fDefaultType = Object.class;

    public AbstractBindValue(AbstractBindFactory model) {
        this.fModel = model;
    }

    public AbstractBindValue(AbstractBindFactory model, Object initialValue) {
        this(model);
        this.fCachedValue = initialValue;
    }

    public AbstractBindValue(AbstractBindFactory model, Object initialValue, Class<?> defaultType) {
        this(model, initialValue);
        this.fDefaultType = defaultType;
    }

    @Override
    public void addChangedListener(IChangedListener listener) {
        this.assertOnModelThread();
        if (listener == null || this.hasListener(listener)) {
            return;
        }
        if (this.fHandler == null && (this.fHhandlers == null || this.fHhandlers.size() == 0)) {
            this.onFirstChangeListenerAdded();
        }
        if (this.fHandler == null) {
            this.fHandler = listener;
        } else {
            if (this.fHhandlers == null) {
                this.fHhandlers = new ArrayList(5);
            }
            this.fHhandlers.add(listener);
        }
        if (BackplanePlugin.DEBUG) {
            String count = new Integer(this.getChangeListenerCount()).toString();
            String s = String.valueOf(this.getTraceName()) + ".addChangedListener(" + count + ")";
            BackplanePlugin.debug(s, IDebugFilter.LISTENERS_COUNT);
        }
    }

    @Override
    public void removeChangedListener(IChangedListener listener) {
        this.assertOnModelThread();
        if (listener == null) {
            return;
        }
        if (this.fHandler == listener) {
            this.fHandler = null;
        } else if (this.fHhandlers != null) {
            this.fHhandlers.remove(listener);
        }
        if (this.fHandler == null && (this.fHhandlers == null || this.fHhandlers.size() == 0)) {
            this.onLastChangedListenerRemoved();
        }
        if (BackplanePlugin.DEBUG) {
            String count = new Integer(this.getChangeListenerCount()).toString();
            String s = String.valueOf(this.getTraceName()) + ".removeChangedListener(" + count + ")";
            BackplanePlugin.debug(s, IDebugFilter.LISTENERS_COUNT);
        }
    }

    public void notifyChangedListeners(IFinished callback) {
        this.assertOnModelThread();
        if (this.fHandler != null) {
            this.fHandler.onValueChanged(callback);
        }
        if (this.fHhandlers != null) {
            for (IChangedListener listener : this.fHhandlers) {
                listener.onValueChanged(callback);
            }
        }
    }

    public void notifyChangedListeners() {
        this.notifyChangedListeners(new FinishedCallback());
    }

    protected void onFirstChangeListenerAdded() {
    }

    protected void onLastChangedListenerRemoved() {
    }

    protected boolean valuesEqual(Object newValue, Object oldValue) {
        if (oldValue == null) {
            return newValue == null;
        }
        return oldValue.equals(newValue);
    }

    @Override
    public void setValue(Object value, IFinished callback) {
        this.assertOnModelThread();
        if (!this.valuesEqual(value, this.fCachedValue)) {
            this.onValueChanged(this.fCachedValue, value);
            this.fCachedValue = value;
            this.notifyChangedListeners();
        }
        if (callback != null) {
            callback.done(null);
        }
    }

    @Override
    public Object getValue() {
        return this.fCachedValue;
    }

    @Override
    public Class<?> getType() {
        if (this.fCachedValue != null) {
            return this.fCachedValue.getClass();
        }
        return this.fDefaultType;
    }

    public AbstractBindFactory getModel() {
        return this.fModel;
    }

    protected void onValueChanged(Object oldValue, Object newValue) {
        if (BackplanePlugin.DEBUG) {
            BackplanePlugin.debug(String.valueOf(this.getTraceName()) + ".value=" + newValue, IDebugFilter.VALUE_CHANGED);
        }
    }

    public String toString() {
        return this.fCachedValue != null ? this.fCachedValue.toString() : super.toString();
    }

    @Override
    public boolean isStale() {
        return this.staleBindImpl != null && this.staleBindImpl.isStale();
    }

    protected void setStale(boolean stale) {
        if (this.staleBindImpl == null) {
            this.staleBindImpl = new StaleBindImpl();
        }
        this.staleBindImpl.setStale(stale);
    }

    protected void onFirstStaleListenerAdded() {
    }

    protected void onLastStaleListenerRemoved() {
    }

    @Override
    public void addStaleListener(IStaleListener listener) {
        if (this.staleBindImpl == null) {
            this.staleBindImpl = new StaleBindImpl();
        }
        if (this.staleBindImpl.addStaleListener(listener)) {
            this.onFirstStaleListenerAdded();
        }
    }

    @Override
    public void removeStaleListener(IStaleListener listener) {
        if (this.staleBindImpl == null) {
            this.staleBindImpl = new StaleBindImpl();
        }
        if (this.staleBindImpl.removeStaleListener(listener)) {
            this.onLastStaleListenerRemoved();
        }
    }

    protected boolean hasStaleListeners() {
        return this.staleBindImpl != null && this.staleBindImpl.hasStaleListeners();
    }

    protected void notifyStaleListeners() {
        if (this.staleBindImpl != null) {
            this.staleBindImpl.notifyStaleListeners();
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    protected void assertOnModelThread() {
        DefaultRealm.assertOnRealmThread();
    }

    private boolean hasListener(IChangedListener listener) {
        return this.fHandler == listener || this.fHhandlers != null && this.fHhandlers.contains(listener);
    }

    private int getChangeListenerCount() {
        int count = 0;
        if (this.fHandler != null) {
            ++count;
        }
        if (this.fHhandlers != null) {
            count += this.fHhandlers.size();
        }
        return count;
    }

    public IRealm getRealm() {
        return DefaultRealm.getInstance();
    }
}

