/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal;

import com.ti.backplane.bind.AbstractBindFactory;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.internal.StockBind;
import java.util.HashMap;

public abstract class AbstractBindFactroryWithStockBinds
extends AbstractBindFactory {
    protected HashMap<String, Object> stockBindInitValues = new HashMap();

    @Override
    protected IBind createNewBind(String uri) {
        return null;
    }

    protected IBind createStockBind(String uri) {
        int index = this.getStockBindIndex(uri);
        if (index == -1) {
            return null;
        }
        Object initValue = this.stockBindInitValues.remove(uri);
        Class defaultType = String.class;
        Class<?>[] defaultTypes = this.getStockBindType();
        if (index < defaultTypes.length) {
            defaultType = defaultTypes[index];
        }
        String globalName = null;
        String[] globalNames = this.getStockBindGlobalName();
        if (index < globalNames.length) {
            globalName = globalNames[index];
        }
        return this.createStockBind(this, initValue, defaultType, globalName, uri);
    }

    protected IBind createStockBind(AbstractBindFactory model, Object initialValue, Class<?> defaultType, String globalName, String uri) {
        return new StockBind(this, initialValue, defaultType, globalName);
    }

    protected void setStockBindValue(final String modelPartURI, final Object obj) {
        int index = this.getStockBindIndex(modelPartURI);
        if (index == -1) {
            return;
        }
        this.getBackplane().getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                IBind bind = AbstractBindFactroryWithStockBinds.this.findBinding(modelPartURI);
                if (bind instanceof IBindValue) {
                    AbstractBindFactroryWithStockBinds.this.stockBindInitValues.put(modelPartURI, obj);
                    String fullURI = "value:" + AbstractBindFactroryWithStockBinds.this.getName() + '.' + modelPartURI;
                    bind = (IBindValue)AbstractBindFactroryWithStockBinds.this.getBackplane().getBinding(fullURI);
                }
                if (bind != null) {
                    ((IBindValue)bind).setValue(obj, null);
                }
            }
        });
    }

    protected String[] getStockBindUri() {
        return new String[0];
    }

    protected Class<?>[] getStockBindType() {
        return new Class[0];
    }

    protected String[] getStockBindGlobalName() {
        return new String[0];
    }

    protected int getStockBindIndex(String uri) {
        String[] stockBindNames = this.getStockBindUri();
        int i = 0;
        while (i < stockBindNames.length) {
            if (uri.equals(stockBindNames[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

