/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal;

import com.ti.backplane.internal.IDebugFilter;
import java.io.PrintStream;
import java.util.Calendar;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;

public class BackplanePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.ti.backplane";
    private static BackplanePlugin plugin;
    public static boolean DEBUG;
    public static boolean[] debugComponent;

    static {
        DEBUG = false;
        debugComponent = new boolean[IDebugFilter.values().length];
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.initTraceFlags();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        this.getPreferences().flush();
    }

    public static BackplanePlugin getDefault() {
        return plugin;
    }

    public IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(BackplanePlugin.getDefault().getBundle().getSymbolicName());
    }

    private void initTraceFlags() {
        DEBUG = "true".equals(Platform.getDebugOption((String)"com.ti.backplane/debug"));
        int i = 0;
        while (i < debugComponent.length) {
            String name = IDebugFilter.values()[i].toString().toLowerCase();
            BackplanePlugin.debugComponent[i] = "true".equals(Platform.getDebugOption((String)("com.ti.backplane/debug/" + name)));
            ++i;
        }
    }

    public static void debug(String debugString, IDebugFilter filterType) {
        BackplanePlugin.printMessage(debugString, filterType, false);
    }

    public static void debug(Throwable t, IDebugFilter filterType) {
        BackplanePlugin.debug(t.getMessage(), filterType);
    }

    private static void printMessage(String debugString, IDebugFilter filterType, boolean error) {
        if (DEBUG) {
            int index;
            debugString = "(" + Calendar.getInstance().getTimeInMillis() + ") " + debugString;
            PrintStream stream = System.out;
            if (error) {
                debugString = "E: " + debugString;
            }
            if (debugComponent[index = filterType.ordinal()]) {
                stream.println(String.valueOf(filterType.toString()) + ": " + debugString);
            }
        }
    }
}

