/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal;

import com.ti.backplane.internal.ErrorReporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class OptionsFileReader {
    static HashMap<String, String> lines = new HashMap();

    public OptionsFileReader(String path) {
        FileReader fr;
        try {
            fr = new FileReader(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ErrorReporter.report("Cannot open file " + path + " for reading.");
            return;
        }
        BufferedReader textReader = new BufferedReader(fr);
        String line = null;
        do {
            int pos;
            try {
                line = textReader.readLine();
            }
            catch (IOException iOException) {
                break;
            }
            if (line == null || (line = line.trim()).startsWith("#") || (pos = line.indexOf("=")) == -1) continue;
            String prop = line.substring(0, pos);
            String value = line.substring(pos + 1);
            lines.put(prop, value);
        } while (line != null);
        try {
            fr.close();
        }
        catch (IOException iOException) {}
    }

    public String get(String propName) {
        return lines.get(propName);
    }

    public int getNumLines() {
        return lines.size();
    }

    public boolean checkFile(String propValue, String propName, boolean file) {
        if (propValue == null || propValue.length() == 0) {
            ErrorReporter.report(String.valueOf(propName) + " not specified.");
            return false;
        }
        File f = new File(propValue);
        if (!f.exists()) {
            ErrorReporter.report(String.valueOf(propValue) + " does not exits.");
            return false;
        }
        if (file && !f.isFile()) {
            ErrorReporter.report(String.valueOf(propValue) + " is not a file.");
            return false;
        }
        if (!file && !f.isDirectory()) {
            ErrorReporter.report(String.valueOf(propValue) + " is not a folder.");
            return false;
        }
        return true;
    }

    public boolean getBoolean(String propValue, String propName, boolean defaltValue) {
        if (propValue == null || propValue.length() == 0) {
            ErrorReporter.report(String.valueOf(propName) + " not specified.");
            return defaltValue;
        }
        if (propValue.equalsIgnoreCase("true")) {
            return true;
        }
        if (propValue.equalsIgnoreCase("false")) {
            return false;
        }
        ErrorReporter.report(String.valueOf(propName) + " expected 'true' or 'false' only.");
        return defaltValue;
    }

    public Integer getInt(String propValue, String propName) {
        if (propValue == null || propValue.length() == 0) {
            ErrorReporter.report(String.valueOf(propName) + " not specified.");
            return null;
        }
        Integer ret = null;
        try {
            ret = new Integer(propValue);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorReporter.report(String.valueOf(propName) + " is not an integer.");
        }
        return ret;
    }

    public String getIndexedProp(String base, int index) {
        String indexText = new Integer(index).toString();
        return lines.get(String.valueOf(base) + "_" + indexText);
    }
}

