/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal;

import com.ti.backplane.bind.IRealm;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;

public abstract class Realm
implements IRealm {
    private static ThreadLocal<Realm> defaultRealm = new ThreadLocal();
    private Thread workerThread;
    private volatile Timer timer;
    Queue<Runnable> workQueue = new LinkedList<Runnable>();

    public static Realm getDefault() {
        return defaultRealm.get();
    }

    protected static Realm setDefault(Realm realm) {
        Realm oldValue = Realm.getDefault();
        defaultRealm.set(realm);
        return oldValue;
    }

    public abstract boolean isCurrent();

    protected static void safeRun(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            System.out.println("Realm.safeRun() " + e);
        }
    }

    public void exec(Runnable runnable) {
        if (this.isCurrent()) {
            Realm.safeRun(runnable);
        } else {
            this.asyncExec(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncExec(Runnable runnable) {
        Queue<Runnable> queue = this.workQueue;
        synchronized (queue) {
            this.ensureWorkerThreadIsRunning();
            this.workQueue.add(runnable);
            this.workQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExec(int milliseconds, final Runnable runnable) {
        if (milliseconds < 0) {
            return;
        }
        if (milliseconds == 0) {
            this.asyncExec(runnable);
        } else {
            Queue<Runnable> queue = this.workQueue;
            synchronized (queue) {
                if (this.timer == null) {
                    this.timer = new Timer(true);
                }
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Realm.this.asyncExec(runnable);
                    }
                }, milliseconds);
            }
        }
    }

    private void ensureWorkerThreadIsRunning() {
        if (this.workerThread == null) {
            this.workerThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (true) {
                            Runnable work = null;
                            Queue<Runnable> queue = Realm.this.workQueue;
                            synchronized (queue) {
                                while (Realm.this.workQueue.isEmpty()) {
                                    Realm.this.workQueue.wait();
                                }
                                work = Realm.this.workQueue.remove();
                            }
                            Realm.this.syncExec(work);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            };
            this.workerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void syncExec(Runnable runnable) {
        SyncRunnable syncRunnable = new SyncRunnable(runnable);
        this.asyncExec(syncRunnable);
        SyncRunnable syncRunnable2 = syncRunnable;
        synchronized (syncRunnable2) {
            while (true) {
                if (syncRunnable.hasRun) {
                    return;
                }
                try {
                    syncRunnable.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static void runWithDefault(Realm realm, Runnable runnable) {
        Realm oldRealm = Realm.getDefault();
        try {
            defaultRealm.set(realm);
            runnable.run();
        }
        finally {
            defaultRealm.set(oldRealm);
        }
    }

    static class SyncRunnable
    implements Runnable {
        boolean hasRun = false;
        private Runnable runnable;

        SyncRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Realm.safeRun(this.runnable);
            }
            catch (Throwable throwable) {
                SyncRunnable syncRunnable = this;
                synchronized (syncRunnable) {
                    this.hasRun = true;
                    this.notifyAll();
                }
                throw throwable;
            }
            SyncRunnable syncRunnable = this;
            synchronized (syncRunnable) {
                this.hasRun = true;
                this.notifyAll();
            }
        }
    }
}

