/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal;

import java.util.HashMap;
import java.util.HashSet;

public class SharedBindValues {
    static SharedBindValues sInstance = new SharedBindValues();
    HashMap<String, HashSet<ISharedBindListener>> fListeners = new HashMap();
    HashMap<String, Object> values = new HashMap();

    public static SharedBindValues getInstance() {
        return sInstance;
    }

    public synchronized void addListener(String name, ISharedBindListener listener) {
        HashSet<ISharedBindListener> listenersSet = this.fListeners.get(name);
        if (listenersSet == null) {
            listenersSet = new HashSet();
            this.fListeners.put(name, listenersSet);
        }
        listenersSet.add(listener);
    }

    public synchronized void removeListener(String name, ISharedBindListener listener) {
        HashSet<ISharedBindListener> listenersSet = this.fListeners.get(name);
        if (listenersSet == null) {
            return;
        }
        listenersSet.remove(listener);
        if (listenersSet.size() == 0) {
            this.fListeners.remove(name);
        }
    }

    public synchronized void setValue(String name, Object newValue) {
        boolean valueChanged;
        boolean hasKey = this.values.containsKey(name);
        boolean bl = valueChanged = !hasKey;
        if (hasKey) {
            Object oldValue = this.values.get(name);
            boolean bl2 = valueChanged = !SharedBindValues.equalObjects(oldValue, newValue);
        }
        if (valueChanged) {
            this.values.put(name, newValue);
            HashSet<ISharedBindListener> listenersSet = this.fListeners.get(name);
            if (listenersSet != null) {
                for (ISharedBindListener l : listenersSet) {
                    l.onValueChanged(newValue);
                }
            }
        }
    }

    public synchronized Object getValue(String name) {
        boolean hasKey = this.values.containsKey(name);
        if (hasKey) {
            return this.values.get(name);
        }
        return null;
    }

    static boolean equalObjects(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static interface ISharedBindListener {
        public void onValueChanged(Object var1);
    }
}

