/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal;

import com.ti.backplane.bind.IStaleListener;
import java.util.ArrayList;

public class StaleBindImpl {
    private Object staleListeners;
    private boolean isStale;

    public boolean isStale() {
        return this.isStale;
    }

    public boolean addStaleListener(IStaleListener listener) {
        if (this.staleListeners == null) {
            this.staleListeners = listener;
            return true;
        }
        if (this.staleListeners instanceof IStaleListener) {
            IStaleListener firstListener = (IStaleListener)this.staleListeners;
            ArrayList<IStaleListener> staleListenersArray = new ArrayList<IStaleListener>(2);
            staleListenersArray.add(firstListener);
            staleListenersArray.add(listener);
            this.staleListeners = staleListenersArray;
        } else {
            ((ArrayList)this.staleListeners).add(listener);
        }
        return false;
    }

    public boolean removeStaleListener(IStaleListener listener) {
        if (this.staleListeners != null) {
            if (this.staleListeners instanceof IStaleListener) {
                if (listener == (IStaleListener)this.staleListeners) {
                    this.staleListeners = null;
                    return true;
                }
            } else {
                ((ArrayList)this.staleListeners).remove(listener);
                if (((ArrayList)this.staleListeners).size() == 0) {
                    this.staleListeners = null;
                    return true;
                }
            }
        }
        return false;
    }

    public void notifyStaleListeners() {
        if (this.staleListeners != null) {
            if (this.staleListeners instanceof IStaleListener) {
                ((IStaleListener)this.staleListeners).onStaleChanged();
            } else {
                for (IStaleListener listener : (ArrayList)this.staleListeners) {
                    listener.onStaleChanged();
                }
            }
        }
    }

    public boolean hasStaleListeners() {
        return this.staleListeners != null;
    }

    public void setStale(boolean stale) {
        if (this.isStale != stale) {
            this.isStale = stale;
            this.notifyStaleListeners();
        }
    }
}

