/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal;

import com.ti.backplane.bind.AbstractBindFactory;
import com.ti.backplane.bind.AbstractBindValue;
import com.ti.backplane.bind.IDisposable;
import com.ti.backplane.internal.SharedBindValues;

public class StockBind
extends AbstractBindValue
implements IDisposable {
    protected SharedBindValues.ISharedBindListener listener;
    protected String fGlobalName;

    public StockBind(AbstractBindFactory model, Object initialValue, Class<?> defaultType, String globalName) {
        super(model, initialValue, defaultType);
        this.fGlobalName = globalName;
        if (this.fGlobalName != null) {
            this.listener = new SharedBindValues.ISharedBindListener(){

                @Override
                public void onValueChanged(Object newValue) {
                    StockBind.this.setValue(newValue, null);
                }
            };
            SharedBindValues.getInstance().addListener(this.fGlobalName, this.listener);
        }
    }

    @Override
    public void dispose() {
        if (this.fGlobalName != null && this.listener != null) {
            SharedBindValues.getInstance().removeListener(this.fGlobalName, this.listener);
            this.listener = null;
        }
    }

    @Override
    protected void onValueChanged(Object oldValue, Object newValue) {
        SharedBindValues.getInstance().setValue(this.fGlobalName, newValue);
    }

    @Override
    public String toString() {
        return this.fGlobalName != null ? this.fGlobalName : super.toString();
    }
}

