/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.bind;

import com.ti.backplane.bind.IBindListener;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IChangedListener;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStatus;

public abstract class AbstractBindDependent {
    public final IBindValue[] fBinds;
    public final BindListener[] fBindListeners;
    public final ChangeListener[] fChangeListeners;

    public AbstractBindDependent(IBindValue[] parents) {
        this.fBinds = parents;
        this.fBindListeners = new BindListener[this.fBinds.length];
        this.fChangeListeners = new ChangeListener[this.fBinds.length];
        int i = 0;
        while (i < this.fBinds.length) {
            if (this.fBinds[i] != null) {
                this.fBindListeners[i] = new BindListener(i);
                this.fBinds[i].addBindListener(this.fBindListeners[i]);
                this.fChangeListeners[i] = new ChangeListener(i);
                this.fBinds[i].addChangedListener(this.fChangeListeners[i]);
            }
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.fBinds.length) {
            if (this.fBinds[i] != null) {
                if (this.fBindListeners[i] != null) {
                    this.fBinds[i].removeBindListener(this.fBindListeners[i]);
                }
                if (this.fChangeListeners[i] != null) {
                    this.fBinds[i].addChangedListener(this.fChangeListeners[i]);
                }
            }
            ++i;
        }
    }

    public abstract void onStatusChanged(int var1, IStatus var2);

    public abstract void onValueChanged(int var1, IFinished var2);

    class BindListener
    implements IBindListener {
        int fIndex;

        BindListener(int index) {
            this.fIndex = index;
        }

        @Override
        public void onStatusChanged(IStatus status) {
            AbstractBindDependent.this.onStatusChanged(this.fIndex, status);
        }
    }

    class ChangeListener
    implements IChangedListener {
        int fIndex;

        ChangeListener(int index) {
            this.fIndex = index;
        }

        @Override
        public void onValueChanged(IFinished callback) {
            AbstractBindDependent.this.onValueChanged(this.fIndex, callback);
        }
    }
}

