/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.bind;

import com.ti.backplane.bind.AbstractBindProvider;
import com.ti.backplane.bind.IBackplane;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindCollection;
import com.ti.backplane.bind.IBindFactory;
import com.ti.backplane.bind.IRealm;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.ErrorReporter;
import com.ti.backplane.internal.bind.DefaultRealm;
import com.ti.backplane.internal.bind.IBackplaneFileOperations;
import com.ti.backplane.internal.bind.IFileLocationResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DefaultBackplane
extends AbstractBindProvider
implements IBackplane,
IBindCollection,
IFileLocationResolver,
IBackplaneFileOperations {
    HashMap<String, IBindFactory> fModels = new HashMap();
    String fDefaultModelId = null;
    private IRealm fRealm;
    private IFileLocationResolver fileLocationResolver;
    private String url;
    private IBackplaneFileOperations fFileOperationsProvider;
    static final String[] PROTOCOLS = new String[]{"value"};

    public void addModel(String modelId, IBindFactory factory) {
        if (modelId == null) {
            ErrorReporter.report("DefaultBackplane.addModel() modelId == null");
            return;
        }
        if (factory == null) {
            ErrorReporter.report("DefaultBackplane.addModel() factory == null");
            return;
        }
        if (this.fModels.get(modelId) != null) {
            ErrorReporter.report("DefaultBackplane.addModel() model " + modelId + " aready registered.");
            return;
        }
        this.fModels.put(modelId, factory);
        factory.init(this, modelId);
        if (this.fModels.size() == 1) {
            this.fDefaultModelId = modelId;
        }
    }

    private IBind createNewBind0(String uri) {
        String[] tokens = this.parseURI(uri);
        if (tokens[0].equals("value")) {
            if (tokens[1] == null) {
                ErrorReporter.report("Default model is not set.");
                return null;
            }
            IBindFactory model = this.fModels.get(tokens[1]);
            return model.getBinding(tokens[2]);
        }
        ErrorReporter.report("Unsupported protocol:" + tokens[0]);
        return null;
    }

    @Override
    protected IBind createNewBind(String name) {
        IBind bind = this.createNewBind0(name);
        if (bind != null) {
            bind.setName(name);
        }
        return bind;
    }

    @Override
    public IBind[] getBindings() {
        ArrayList<IBind> all = new ArrayList<IBind>();
        for (Map.Entry<String, IBindFactory> i : this.fModels.entrySet()) {
            IBindFactory f = i.getValue();
            if (!(f instanceof IBindCollection)) continue;
            IBindCollection fi = (IBindCollection)((Object)f);
            all.addAll(Arrays.asList(fi.getBindings()));
        }
        return all.toArray(new IBind[0]);
    }

    @Override
    public void dispose() {
        for (IBindFactory m : this.fModels.values()) {
            m.dispose();
        }
        this.fModels = new HashMap();
        this.fDefaultModelId = null;
    }

    public void setDefaultModel(String modelId) {
        this.fDefaultModelId = modelId;
        this.clearCache();
    }

    public String getDefaultModel() {
        return this.fDefaultModelId;
    }

    private String[] parseURI(String uri) {
        String[] ret = new String[3];
        int i = 0;
        while (i < PROTOCOLS.length) {
            String protocol = String.valueOf(PROTOCOLS[i]) + ':';
            if (uri.startsWith(protocol)) {
                ret[0] = PROTOCOLS[i];
                uri = uri.replaceFirst(protocol, "");
                break;
            }
            ++i;
        }
        for (String modelId : this.fModels.keySet()) {
            String model = String.valueOf(modelId) + '.';
            if (!uri.startsWith(model)) continue;
            ret[1] = modelId;
            uri = uri.replaceFirst(model, "");
            break;
        }
        if (ret[1] == null) {
            ret[1] = this.getDefaultModel();
        }
        ret[2] = uri;
        return ret;
    }

    @Override
    public synchronized IRealm getRealm() {
        if (this.fRealm == null) {
            this.fRealm = DefaultRealm.getInstance();
        }
        return this.fRealm;
    }

    public void setFileLocationResolver(IFileLocationResolver resolver) {
        this.fileLocationResolver = resolver;
    }

    public void setFileOperationsProvider(IBackplaneFileOperations provider) {
        this.fFileOperationsProvider = provider;
    }

    @Override
    public String resolveAppPath(String appPath) {
        if (this.fileLocationResolver == null) {
            return null;
        }
        return this.fileLocationResolver.resolveAppPath(appPath);
    }

    @Override
    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    @Override
    public String getLocalPath(String serverPath, int storageType) {
        if (this.fFileOperationsProvider == null) {
            return null;
        }
        return this.fFileOperationsProvider.getLocalPath(serverPath, storageType);
    }

    @Override
    public String createNewFile(String localFile, int storageType, IStatus[] status) {
        if (this.fFileOperationsProvider == null) {
            return null;
        }
        return this.fFileOperationsProvider.createNewFile(localFile, storageType, status);
    }

    @Override
    public boolean isLocalOperationAllowed() {
        if (this.fFileOperationsProvider == null) {
            return false;
        }
        return this.fFileOperationsProvider.isLocalOperationAllowed();
    }

    @Override
    public boolean ensureQuota(int storageType, long bytesRequested) {
        if (this.fFileOperationsProvider == null) {
            return false;
        }
        return this.fFileOperationsProvider.ensureQuota(storageType, bytesRequested);
    }
}

