/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.bind;

import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.internal.bind.DefaultBinding;
import com.ti.backplane.internal.bind.IBindWidget;
import com.ti.backplane.internal.bind.IBinder;
import java.util.HashSet;

public class DefaultBinder
implements IBinder {
    private HashSet<DefaultBinding> bindings = new HashSet();

    @Override
    public void bind(IBindValue target, IBindValue model, boolean modelToTarget, boolean enabled) {
        this.bindings.add(new DefaultBinding(model, target, modelToTarget, enabled));
    }

    @Override
    public void unbind(IBindValue target, IBindValue model) {
        for (DefaultBinding b : this.bindings) {
            if (target != b.target || model != b.model) continue;
            this.bindings.remove(b);
            return;
        }
    }

    @Override
    public void unbindAll() {
        this.bindings.clear();
    }

    public void synchEnabledState() {
        IBindValue mb;
        HashSet<IBindValue> enabled = new HashSet<IBindValue>();
        HashSet<IBindValue> disabled = new HashSet<IBindValue>();
        for (DefaultBinding binding : this.bindings) {
            if (!(binding.target instanceof IBindWidget)) continue;
            IBindWidget wb = (IBindWidget)((Object)binding.target);
            if (wb.getUpdateEnabled()) {
                enabled.add(binding.model);
                continue;
            }
            disabled.add(binding.model);
        }
        for (DefaultBinding binding : this.bindings) {
            mb = binding.model;
            if (!disabled.contains(mb) || enabled.contains(mb)) continue;
            binding.setEnabled(false);
        }
        for (DefaultBinding binding : this.bindings) {
            mb = binding.model;
            if (disabled.contains(mb) && !enabled.contains(mb)) continue;
            binding.setEnabled(true);
        }
    }
}

