/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.bind;

import com.ti.backplane.bind.IBindListener;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IChangedListener;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.FinishedCallback;
import com.ti.backplane.internal.dataconversion.DataConverter;

public class DefaultBinding {
    protected IBindValue model;
    protected IBindValue target;
    protected ModelBindListener modelBindListener = new ModelBindListener();
    protected TargetBindListener targetBindListener = new TargetBindListener();
    private ModelChangedListener modelChangedListener = new ModelChangedListener();
    private TargetChangedListener targetChangedListener = new TargetChangedListener();
    private boolean delayedSetModelValue = false;
    private boolean delayedSetTargetValue = false;
    private boolean enabled = true;
    private boolean valueSynchronizedFirstTime = false;
    private boolean modelToTarget = true;

    DefaultBinding(IBindValue model, IBindValue target, boolean modelToTarget, boolean enabled) {
        this.model = model;
        this.target = target;
        this.enabled = enabled;
        this.valueSynchronizedFirstTime = enabled;
        this.modelToTarget = modelToTarget;
        target.addBindListener(this.targetBindListener);
        target.addChangedListener(this.targetChangedListener);
        if (enabled) {
            model.addBindListener(this.modelBindListener);
            model.addChangedListener(this.modelChangedListener);
            if (modelToTarget) {
                this.modelChangedListener.onValueChanged(new FinishedCallback());
                this.modelBindListener.onStatusChanged(model.getStatus());
            } else {
                this.targetChangedListener.onValueChanged(new FinishedCallback());
            }
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            if (!this.enabled) {
                this.enabled = enabled;
                if (this.model != null) {
                    this.model.addBindListener(this.modelBindListener);
                    this.model.addChangedListener(this.modelChangedListener);
                }
                if (!this.valueSynchronizedFirstTime) {
                    this.valueSynchronizedFirstTime = true;
                    if (this.modelToTarget) {
                        this.modelChangedListener.onValueChanged(new FinishedCallback());
                        this.modelBindListener.onStatusChanged(this.model == null ? null : this.model.getStatus());
                    } else {
                        this.targetChangedListener.onValueChanged(new FinishedCallback());
                    }
                } else {
                    this.modelChangedListener.onValueChanged(new FinishedCallback());
                    this.modelBindListener.onStatusChanged(this.model == null ? null : this.model.getStatus());
                }
            }
        } else if (this.enabled) {
            this.enabled = enabled;
            if (this.model != null) {
                this.model.removeBindListener(this.modelBindListener);
                this.model.removeChangedListener(this.modelChangedListener);
            }
        }
    }

    Class<?> properGetType(IBindValue bind, Object value) {
        return value != null ? value.getClass() : bind.getType();
    }

    boolean isTypeNull(IBindValue bind) {
        return bind.getType() == null;
    }

    protected static boolean valuesEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return o1 == null;
        }
        return o1.equals(o2);
    }

    class ModelBindListener
    implements IBindListener {
        ModelBindListener() {
        }

        @Override
        public void onStatusChanged(IStatus status) {
            DefaultBinding.this.target.setStatus(status);
        }
    }

    class ModelChangedListener
    implements IChangedListener {
        ModelChangedListener() {
        }

        @Override
        public void onValueChanged(IFinished callback) {
            if (DefaultBinding.this.isTypeNull(DefaultBinding.this.target)) {
                DefaultBinding.this.delayedSetTargetValue = true;
                callback.done(null);
                return;
            }
            Object valueForTarget = DefaultBinding.this.model.getValue();
            Class<?> modelType = DefaultBinding.this.properGetType(DefaultBinding.this.model, valueForTarget);
            if (DefaultBinding.this.delayedSetModelValue) {
                callback.done(null);
                if (modelType == null) {
                    return;
                }
                Object valueForModel = DefaultBinding.this.target.getValue();
                Class<?> targetType = DefaultBinding.this.properGetType(DefaultBinding.this.target, valueForModel);
                if (modelType != targetType) {
                    IStatus[] s = new IStatus[1];
                    valueForModel = new DataConverter().convert(targetType, modelType, valueForModel, DefaultBinding.this.model, s);
                    if (s[0] != null && valueForModel != null) {
                        DefaultBinding.this.target.setStatus(s[0]);
                        return;
                    }
                }
                DefaultBinding.this.delayedSetModelValue = false;
                if (!DefaultBinding.valuesEqual(valueForModel, DefaultBinding.this.model.getValue())) {
                    DefaultBinding.this.model.setValue(valueForModel, null);
                }
                return;
            }
            if (valueForTarget == null && modelType == null) {
                callback.done(null);
                return;
            }
            Object targetValue = DefaultBinding.this.target.getValue();
            Class<?> targetType = DefaultBinding.this.properGetType(DefaultBinding.this.target, targetValue);
            if (modelType != targetType) {
                IStatus[] s = new IStatus[1];
                valueForTarget = new DataConverter().convert(modelType, targetType, valueForTarget, DefaultBinding.this.target, s);
                if (s[0] != null && valueForTarget != null) {
                    DefaultBinding.this.model.setStatus(s[0]);
                    callback.done(null);
                    return;
                }
            }
            if (!DefaultBinding.valuesEqual(valueForTarget, targetValue)) {
                DefaultBinding.this.target.setValue(valueForTarget, callback);
            } else {
                callback.done(null);
            }
        }
    }

    class TargetBindListener
    implements IBindListener {
        TargetBindListener() {
        }

        @Override
        public void onStatusChanged(IStatus status) {
            DefaultBinding.this.model.setStatus(status);
        }
    }

    class TargetChangedListener
    implements IChangedListener {
        TargetChangedListener() {
        }

        @Override
        public void onValueChanged(IFinished callback) {
            if (DefaultBinding.this.isTypeNull(DefaultBinding.this.model)) {
                DefaultBinding.this.delayedSetModelValue = true;
                callback.done(null);
                return;
            }
            if (DefaultBinding.this.delayedSetTargetValue) {
                Object targetValue;
                Class<?> targetType;
                callback.done(null);
                if (DefaultBinding.this.isTypeNull(DefaultBinding.this.target)) {
                    return;
                }
                Object valueForTarget = DefaultBinding.this.model.getValue();
                Class<?> modelType = DefaultBinding.this.properGetType(DefaultBinding.this.model, valueForTarget);
                if (modelType != (targetType = DefaultBinding.this.properGetType(DefaultBinding.this.target, targetValue = DefaultBinding.this.target.getValue()))) {
                    IStatus[] s = new IStatus[1];
                    valueForTarget = new DataConverter().convert(modelType, targetType, valueForTarget, DefaultBinding.this.target, s);
                    if (s[0] != null && valueForTarget != null) {
                        DefaultBinding.this.model.setStatus(s[0]);
                        return;
                    }
                }
                DefaultBinding.this.delayedSetTargetValue = false;
                if (!DefaultBinding.valuesEqual(valueForTarget, targetValue)) {
                    DefaultBinding.this.target.setValue(valueForTarget, null);
                }
                return;
            }
            Object modelValue = DefaultBinding.this.model.getValue();
            Class<?> modelType = DefaultBinding.this.properGetType(DefaultBinding.this.model, modelValue);
            Object valueForModel = DefaultBinding.this.target.getValue();
            Class<?> targetType = DefaultBinding.this.properGetType(DefaultBinding.this.target, valueForModel);
            if (valueForModel == null && targetType == null) {
                callback.done(null);
                return;
            }
            if (targetType != modelType) {
                IStatus[] s = new IStatus[1];
                valueForModel = new DataConverter().convert(targetType, modelType, valueForModel, DefaultBinding.this.model, s);
                if (s[0] != null && valueForModel != null) {
                    DefaultBinding.this.model.setStatus(s[0]);
                    callback.done(null);
                    return;
                }
            }
            if (!DefaultBinding.valuesEqual(valueForModel, DefaultBinding.this.model.getValue())) {
                DefaultBinding.this.model.setValue(valueForModel, callback);
            } else {
                callback.done(null);
            }
        }
    }
}

