/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.bind;

import com.ti.backplane.bind.IRealm;
import com.ti.backplane.internal.BackplanePlugin;
import com.ti.backplane.internal.IDebugFilter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class DefaultRealm
implements IRealm {
    protected static DefaultRealm instance = new DefaultRealm();
    ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    static Thread realmThread = null;

    public static IRealm getInstance() {
        return instance;
    }

    @Override
    public void asyncExec(Runnable runnable) {
        this.executor.execute(new ReportingRunnable(runnable));
    }

    public static void assertOnRealmThread() {
        assert (realmThread == null || realmThread == Thread.currentThread());
    }

    private static class ReportingRunnable
    implements Runnable {
        Runnable runnable;

        ReportingRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            if (realmThread == null) {
                realmThread = Thread.currentThread();
            }
            try {
                long startTime = 0L;
                if (BackplanePlugin.DEBUG) {
                    startTime = System.currentTimeMillis();
                }
                this.runnable.run();
                if (BackplanePlugin.DEBUG) {
                    long duration = System.currentTimeMillis() - startTime;
                    String className = this.runnable.getClass().toString();
                    BackplanePlugin.debug("DefaultRealm.run time = " + duration + " Class = " + className, IDebugFilter.UPDATE);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

