/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.bind;

import com.ti.backplane.bind.AbstractBind;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.expressionParser.IBindingContext;
import com.ti.backplane.internal.expressionParser.UriExpressionParser;
import com.ti.backplane.internal.expressionParser.UriParseException;

class URIParser {
    URIParser() {
    }

    public static IBind parse(String uri, IBindingContext context) {
        if (!uri.startsWith("value:")) {
            uri = "value:" + uri;
        }
        try {
            return UriExpressionParser.parse(uri, context);
        }
        catch (UriParseException e) {
            ErrorBinding result = new ErrorBinding();
            result.setStatus(new IStatus(){

                @Override
                public IStatus.StatusType getType() {
                    return IStatus.StatusType.ERROR;
                }

                @Override
                public String getMessage() {
                    return e.getLocalizedMessage();
                }

                @Override
                public String getId() {
                    return "";
                }
            });
            return result;
        }
    }

    private static class ErrorBinding
    extends AbstractBind {
        private ErrorBinding() {
        }
    }
}

