/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.dataconversion;

import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.dataconversion.DataConverter;
import com.ti.backplane.internal.datatypes.IDataConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

class ArrayConversions {
    ArrayConversions() {
    }

    static void addAll(DataConverter.Factory factory) {
        factory.addConverter(Map.class, Collection.class, new MapToCollectionConverter());
        factory.addConverter(Map.class, Object[].class, new MapToArrayConverter());
        factory.addConverter(Collection.class, Object[].class, new CollectionToArrayConverter());
        factory.addConverter(Collection.class, String.class, new CollectionToStringConverter());
        factory.addConverter(String[].class, ArrayList.class, new ObjectArrayToArrayList());
        factory.addConverter(Long[].class, ArrayList.class, new ObjectArrayToArrayList());
        factory.addConverter(Double[].class, ArrayList.class, new ObjectArrayToArrayList());
        factory.addConverter(Boolean[].class, ArrayList.class, new ObjectArrayToArrayList());
    }

    private static class CollectionToArrayConverter
    implements IDataConverter {
        private CollectionToArrayConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            return ((Collection)source).toArray();
        }
    }

    private static class CollectionToStringConverter
    implements IDataConverter {
        private CollectionToStringConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            Collection c = (Collection)source;
            return Arrays.toString(c.toArray());
        }
    }

    private static class MapToArrayConverter
    implements IDataConverter {
        private MapToArrayConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            return ((Map)source).values().toArray();
        }
    }

    private static class MapToCollectionConverter
    implements IDataConverter {
        private MapToCollectionConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            return ((Map)source).values();
        }
    }

    private static class ObjectArrayToArrayList<T>
    implements IDataConverter {
        private ObjectArrayToArrayList() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            Object[] input = (Object[])source;
            ArrayList<Object> result = new ArrayList<Object>(input.length);
            int i = 0;
            while (i < input.length) {
                result.add(input[i]);
                ++i;
            }
            return result;
        }
    }
}

