/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.dataconversion;

import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.dataconversion.DataConverter;
import com.ti.backplane.internal.datatypes.IDataConverter;

class BooleanConversions {
    BooleanConversions() {
    }

    static void addAll(DataConverter.Factory factory) {
        factory.addConverter(Boolean.class, String.class, new BooleanToStringConverter());
        factory.addConverter(Boolean.class, Double.class, new BooleanToDoubleConverter());
        factory.addConverter(Boolean.class, Float.class, new BooleanToFloatConverter());
        factory.addConverter(Boolean.class, Long.class, new BooleanToLongConverter());
        factory.addConverter(Boolean.class, Integer.class, new BooleanToIntegerConverter());
        factory.addConverter(Boolean.class, Short.class, new BooleanToShortConverter());
        factory.addConverter(Boolean.class, Byte.class, new BooleanToByteConverter());
    }

    private static class BooleanToByteConverter
    implements IDataConverter {
        private BooleanToByteConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            return new Byte((byte)((Boolean)source != false ? 1 : 0));
        }
    }

    private static class BooleanToDoubleConverter
    implements IDataConverter {
        private BooleanToDoubleConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            return new Double((Boolean)source != false ? 1.0 : 0.0);
        }
    }

    private static class BooleanToFloatConverter
    implements IDataConverter {
        private BooleanToFloatConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            return new Float((Boolean)source != false ? 1.0 : 0.0);
        }
    }

    private static class BooleanToIntegerConverter
    implements IDataConverter {
        private BooleanToIntegerConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            return new Integer((Boolean)source != false ? 1 : 0);
        }
    }

    private static class BooleanToLongConverter
    implements IDataConverter {
        private BooleanToLongConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            return new Long((Boolean)source != false ? 1 : 0);
        }
    }

    private static class BooleanToShortConverter
    implements IDataConverter {
        private BooleanToShortConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            return new Short((short)((Boolean)source != false ? 1 : 0));
        }
    }

    private static class BooleanToStringConverter
    implements IDataConverter {
        private BooleanToStringConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            return new String((Boolean)source != false ? "true" : "false");
        }
    }
}

