/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.dataconversion;

import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.dataconversion.ArrayConversions;
import com.ti.backplane.internal.dataconversion.BooleanConversions;
import com.ti.backplane.internal.dataconversion.NumberConversions;
import com.ti.backplane.internal.dataconversion.StringConversions;
import com.ti.backplane.internal.datatypes.IDataConverter;
import com.ti.backplane.internal.datatypes.IDataConverterFactory;
import java.util.HashMap;

public class DataConverter {
    public static IDataConverterFactory factory = new Factory();
    private IDataConverter dataConverter;
    private Class<?> sourceType;
    private Class<?> destinationType;

    public Object convert(Class<?> sourceType, Class<?> destinationType, Object source, Object destination, IStatus[] status) {
        if (sourceType == destinationType || source == null) {
            return source;
        }
        if (this.sourceType != sourceType || this.destinationType != destinationType) {
            this.sourceType = sourceType;
            this.destinationType = destinationType;
            this.dataConverter = null;
            if (source instanceof IDataConverterFactory) {
                this.dataConverter = ((IDataConverterFactory)source).getConverter(sourceType, destinationType);
            }
            if (this.dataConverter == null && destination != null && destination instanceof IDataConverterFactory) {
                this.dataConverter = ((IDataConverterFactory)destination).getConverter(sourceType, destinationType);
            }
            if (this.dataConverter == null) {
                this.dataConverter = factory.getConverter(sourceType, destinationType);
            }
        }
        if (this.dataConverter == null) {
            if (destinationType.equals(String.class) && source != null) {
                return source.toString();
            }
            status[0] = AbstractStatus.createErrorStatus("There is no converter from " + sourceType + " to " + destinationType);
            return null;
        }
        return this.dataConverter.convert(source, status);
    }

    static class Factory
    implements IDataConverterFactory {
        private HashMap<Class<?>, HashMap<Class<?>, IDataConverter>> converters;

        private Factory() {
            BooleanConversions.addAll(this);
            NumberConversions.addAll(this);
            StringConversions.addAll(this);
            ArrayConversions.addAll(this);
        }

        @Override
        public IDataConverter getConverter(Class<?> sourceType, Class<?> destinationType) {
            HashMap<Class<?>, IDataConverter> sourceConverterList;
            if (this.converters != null && (sourceConverterList = this.converters.get(sourceType)) != null) {
                return sourceConverterList.get(destinationType);
            }
            return null;
        }

        public void addConverter(Class<?> sourceType, Class<?> destinationType, IDataConverter converter) {
            HashMap<Class<Object>, IDataConverter> sourceConverterList;
            if (this.converters == null) {
                this.converters = new HashMap();
            }
            if ((sourceConverterList = this.converters.get(sourceType)) == null) {
                sourceConverterList = new HashMap();
                this.converters.put(sourceType, sourceConverterList);
            }
            sourceConverterList.put(destinationType, converter);
        }
    }
}

