/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.dataconversion;

import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.ErrorStatus;
import com.ti.backplane.internal.dataconversion.DataConverter;
import com.ti.backplane.internal.datatypes.IDataConverter;
import java.util.ArrayList;

class StringConversions {
    StringConversions() {
    }

    static void addAll(DataConverter.Factory factory) {
        factory.addConverter(String.class, Boolean.class, new StringToBooleanConverter());
        factory.addConverter(String.class, Double.class, new StringToDoubleConverter());
        factory.addConverter(String.class, Float.class, new StringToFloatConverter());
        factory.addConverter(String.class, Long.class, new StringToLongConverter());
        factory.addConverter(String.class, Integer.class, new StringToIntegerConverter());
        factory.addConverter(String.class, Short.class, new StringToShortConverter());
        factory.addConverter(String.class, Byte.class, new StringToByteConverter());
        factory.addConverter(String.class, ArrayList.class, new StringToArrayListConverter());
    }

    private static int getRadix(String source) {
        char digit;
        int radix = 10;
        if (source.startsWith("0") && source.length() > 2 && Character.isLetter(digit = source.charAt(1))) {
            digit = Character.toLowerCase(digit);
            switch (digit) {
                case 'x': {
                    radix = 16;
                    break;
                }
                case 'b': {
                    radix = 2;
                    break;
                }
                case 'o': {
                    radix = 8;
                }
            }
        }
        return radix;
    }

    private static String stripRadixPrefix(String source) {
        if (source.length() > 1 && source.startsWith("0") && source.length() > 2 && Character.isLetter(source.charAt(1))) {
            source = source.substring(2);
        } else {
            int dot = source.indexOf(46);
            if (dot >= 0) {
                source = source.substring(0, dot);
            }
        }
        return source;
    }

    static class StringToArrayListConverter
    implements IDataConverter {
        StringToArrayListConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            String s = (String)source;
            if (!s.startsWith("[")) {
                status[0] = new ErrorStatus("Collections values start with \"[.");
                return null;
            }
            if (!s.endsWith("]")) {
                status[0] = new ErrorStatus("Collections values end with \"].");
                return null;
            }
            boolean allLong = !(s = s.substring(1, s.length() - 1)).contains(".");
            ArrayList<Double> l = new ArrayList<Double>();
            String[] values = s.split(",");
            try {
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String v = stringArray[n2];
                    Number n3 = null;
                    n3 = allLong ? (Number)Long.parseLong(StringConversions.stripRadixPrefix(v), StringConversions.getRadix(v)) : (Number)Double.parseDouble(v);
                    l.add((Double)n3);
                    ++n2;
                }
                return l;
            }
            catch (NumberFormatException e) {
                status[0] = new ErrorStatus(e.getMessage());
                return null;
            }
        }
    }

    static class StringToBooleanConverter
    implements IDataConverter {
        StringToBooleanConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            String s = (String)source;
            if (s.equals("true")) {
                return Boolean.TRUE;
            }
            if (s.equals("false")) {
                return Boolean.FALSE;
            }
            status[0] = new ErrorStatus("true or false values expected.");
            return null;
        }
    }

    static class StringToByteConverter
    implements IDataConverter {
        StringToByteConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            try {
                return Byte.parseByte(StringConversions.stripRadixPrefix((String)source), StringConversions.getRadix((String)source));
            }
            catch (NumberFormatException e) {
                status[0] = new ErrorStatus(e.getMessage());
                return null;
            }
        }
    }

    static class StringToDoubleConverter
    implements IDataConverter {
        StringToDoubleConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            try {
                return Double.parseDouble((String)source);
            }
            catch (NumberFormatException e) {
                status[0] = new ErrorStatus(e.getMessage());
                return null;
            }
        }
    }

    static class StringToFloatConverter
    implements IDataConverter {
        StringToFloatConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            try {
                return Float.valueOf(Float.parseFloat((String)source));
            }
            catch (NumberFormatException e) {
                status[0] = new ErrorStatus(e.getMessage());
                return null;
            }
        }
    }

    static class StringToIntegerConverter
    implements IDataConverter {
        StringToIntegerConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            try {
                return Integer.parseInt(StringConversions.stripRadixPrefix((String)source), StringConversions.getRadix((String)source));
            }
            catch (NumberFormatException numberFormatException) {
                status[0] = new ErrorStatus("Cannot convert '" + source + "' to an integer.");
                return null;
            }
        }
    }

    static class StringToLongConverter
    implements IDataConverter {
        StringToLongConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            try {
                return Long.parseLong(StringConversions.stripRadixPrefix((String)source), StringConversions.getRadix((String)source));
            }
            catch (NumberFormatException e) {
                status[0] = new ErrorStatus(e.getMessage());
                return null;
            }
        }
    }

    static class StringToShortConverter
    implements IDataConverter {
        StringToShortConverter() {
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            try {
                return Short.parseShort(StringConversions.stripRadixPrefix((String)source), StringConversions.getRadix((String)source));
            }
            catch (NumberFormatException e) {
                status[0] = new ErrorStatus(e.getMessage());
                return null;
            }
        }
    }
}

