/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.datatypes;

import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.ErrorStatus;
import com.ti.backplane.internal.dataconversion.DataConverter;
import com.ti.backplane.internal.datatypes.IDataConverter;
import com.ti.backplane.internal.datatypes.IDataConverterFactory;
import java.util.Formatter;
import java.util.HashMap;
import java.util.IllegalFormatException;

public class FormattedString
implements Comparable<FormattedString>,
IDataConverterFactory {
    private static HashMap<Class<?>, IDataConverter> fromStringconverters;
    private static HashMap<String, IDataConverter> toStringConverters;
    private String value;
    private String fmt;

    @Override
    public int compareTo(FormattedString arg0) {
        return this.value.compareTo(arg0.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FormattedString) {
            return this.value.equals(((FormattedString)obj).value);
        }
        if (obj instanceof String) {
            return this.value.equals(obj);
        }
        return super.equals(obj);
    }

    @Override
    public IDataConverter getConverter(Class<?> sourceType, Class<?> destinationType) {
        IDataConverter result = null;
        if (sourceType == FormattedString.class) {
            if (fromStringconverters != null) {
                result = fromStringconverters.get(destinationType);
            }
            if (result == null && (result = DataConverter.factory.getConverter(String.class, destinationType)) != null) {
                result = new FormattedStringToAnyConverter(result);
                if (fromStringconverters == null) {
                    fromStringconverters = new HashMap();
                }
                fromStringconverters.put(destinationType, result);
            }
        } else if (destinationType == FormattedString.class) {
            if (toStringConverters != null) {
                result = toStringConverters.get(this.fmt);
            }
            if (result == null) {
                if (toStringConverters == null) {
                    toStringConverters = new HashMap();
                }
                result = new NumberToFormattedStringConverter(this.fmt);
                toStringConverters.put(this.fmt, result);
            }
        }
        return result;
    }

    public FormattedString(String value, String fmt) {
        this.value = value;
        this.fmt = fmt;
    }

    public String toString() {
        return this.value;
    }

    private static class FormattedStringToAnyConverter
    implements IDataConverter {
        private IDataConverter stringConverter;

        private FormattedStringToAnyConverter(IDataConverter stringConverter) {
            this.stringConverter = stringConverter;
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            return this.stringConverter.convert(((FormattedString)source).value, status);
        }
    }

    private class NumberToFormattedStringConverter
    implements IDataConverter {
        private String fmt;

        private NumberToFormattedStringConverter(String fmt) {
            this.fmt = fmt;
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            try {
                return this.tryConvert(source, status);
            }
            catch (IllegalFormatException illegalFormatException) {
                if (source instanceof Number) {
                    Long l = ((Number)source).longValue();
                    try {
                        return this.tryConvert(l, status);
                    }
                    catch (IllegalFormatException illegalFormatException2) {
                        Double d = ((Number)source).doubleValue();
                        try {
                            return this.tryConvert(d, status);
                        }
                        catch (IllegalFormatException illegalFormatException3) {}
                    }
                }
                status[0] = new ErrorStatus("Formatting exception. Formatting " + this.fmt + " does not apply to " + source.getClass());
                return source.toString();
            }
        }

        Object tryConvert(Object source, IStatus[] status) {
            Formatter formatter = new Formatter();
            try {
                formatter.format(this.fmt, source);
                FormattedString formattedString = new FormattedString(formatter.toString(), this.fmt);
                return formattedString;
            }
            finally {
                formatter.close();
            }
        }
    }
}

