/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.datatypes;

import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.dataconversion.DataConverter;
import com.ti.backplane.internal.datatypes.IDataConverter;
import com.ti.backplane.internal.datatypes.IDataConverterFactory;
import java.util.HashMap;

public class QValue
implements Comparable<QValue>,
IDataConverterFactory {
    private static HashMap<Class<?>, IDataConverter> fromQValueConverters;
    private static HashMap<Integer, IDataConverter> toQValueConverters;
    private double value;
    private int q;

    @Override
    public int compareTo(QValue qValue) {
        return this.value < qValue.value ? -1 : (this.value > qValue.value ? 1 : 0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof QValue) {
            return this.value == ((QValue)obj).value;
        }
        if (obj instanceof Number) {
            return this.value == ((Number)obj).doubleValue();
        }
        return super.equals(obj);
    }

    public void setQ(int q) {
        this.q = q;
    }

    public int getQ() {
        return this.q;
    }

    double getValue() {
        return this.value;
    }

    void setValue(long value) {
        this.value = (double)value / (double)(1L << this.q);
    }

    @Override
    public IDataConverter getConverter(Class<?> sourceType, Class<?> destinationType) {
        IDataConverter result = null;
        if (sourceType == QValue.class) {
            if (fromQValueConverters != null) {
                result = fromQValueConverters.get(destinationType);
            }
            if (result == null && (result = DataConverter.factory.getConverter(Double.class, destinationType)) != null) {
                result = new QValueToAnyConverter(result);
                if (fromQValueConverters == null) {
                    fromQValueConverters = new HashMap();
                }
                fromQValueConverters.put(destinationType, result);
            }
        } else if (destinationType == QValue.class) {
            if (toQValueConverters != null) {
                result = toQValueConverters.get(this.q);
            }
            if (result == null) {
                if (toQValueConverters == null) {
                    toQValueConverters = new HashMap();
                }
                result = new NumberToQValueConverter(this.q);
                toQValueConverters.put(new Integer(this.q), result);
            }
        }
        return result;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    private class NumberToQValueConverter
    implements IDataConverter {
        private int q;

        private NumberToQValueConverter(int q) {
            this.q = q;
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            QValue result = new QValue();
            result.setQ(this.q);
            result.setValue(((Number)source).longValue());
            return result;
        }
    }

    private static class QValueToAnyConverter
    implements IDataConverter {
        private IDataConverter doubleConverter;

        private QValueToAnyConverter(IDataConverter doubleConverter) {
            this.doubleConverter = doubleConverter;
        }

        @Override
        public Object convert(Object source, IStatus[] status) {
            return this.doubleConverter.convert(new Double(((QValue)source).value), status);
        }
    }
}

