/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.AbstractBind;
import com.ti.backplane.bind.AbstractBindProvider;
import com.ti.backplane.bind.IBindListener;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IChangedListener;
import com.ti.backplane.bind.IDisposable;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStaleListener;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.expressionParser.AbstractUriBinding;
import com.ti.backplane.internal.expressionParser.IBindingContext;
import com.ti.backplane.internal.expressionParser.IOperatorFactory;
import com.ti.backplane.internal.expressionParser.IUriElement;
import com.ti.backplane.internal.expressionParser.IUriValue;
import com.ti.backplane.internal.expressionParser.UriParseException;
import java.lang.reflect.Array;

abstract class AbstractBinaryOperator<T extends IBindValue, V extends IUriElement<T>>
implements IUriValue {
    protected V leftOperand;
    protected V rightOperand;
    protected String operator;

    AbstractBinaryOperator() {
    }

    protected abstract Binding<T> createBinding();

    @Override
    public T bind(IBindingContext context) {
        Binding<T> result = this.createBinding();
        result.leftOperand = (IBindValue)this.leftOperand.bind(context);
        result.rightOperand = (IBindValue)this.rightOperand.bind(context);
        return (T)result;
    }

    @Override
    public String toOperandText() {
        StringBuilder text = new StringBuilder();
        text.append(this.leftOperand.toOperandText());
        text.append(" ");
        text.append(this.operator);
        text.append(" ");
        text.append(this.rightOperand.toOperandText());
        return text.toString();
    }

    public String toString() {
        return "value:" + this.toOperandText();
    }

    static abstract class Binding<T extends IBindValue>
    extends AbstractBind
    implements IBindValue,
    IDisposable {
        protected T leftOperand;
        protected T rightOperand;
        static final Class<?>[] promotionTable = new Class[]{Array.class, String.class, Double.class, Float.class, Long.class, Integer.class, Short.class, Byte.class, Boolean.class};
        static final int SCORE_DOUBLE = Binding.getPromotionScore(Double.class);
        static final int SCORE_LONG = Binding.getPromotionScore(Long.class);

        Binding() {
        }

        protected abstract String getOperator();

        public String toString() {
            StringBuilder result = new StringBuilder(this.leftOperand.toString());
            result.append(' ');
            result.append(this.getOperator());
            result.append(' ');
            result.append(this.rightOperand.toString());
            return result.toString();
        }

        @Override
        public void setValue(Object value, IFinished callback) {
            callback.done(null);
        }

        @Override
        public void addChangedListener(IChangedListener listener) {
            this.leftOperand.addChangedListener(listener);
            this.rightOperand.addChangedListener(listener);
        }

        @Override
        public void removeChangedListener(IChangedListener listener) {
            this.leftOperand.removeChangedListener(listener);
            this.rightOperand.removeChangedListener(listener);
        }

        @Override
        public void addBindListener(IBindListener listener) {
            super.addBindListener(listener);
            this.leftOperand.addBindListener(listener);
            this.rightOperand.addBindListener(listener);
        }

        @Override
        public void removeBindListener(IBindListener listener) {
            super.addBindListener(listener);
            this.leftOperand.removeBindListener(listener);
            this.rightOperand.removeBindListener(listener);
        }

        @Override
        public void dispose() {
            if (this.leftOperand instanceof IDisposable) {
                ((IDisposable)this.leftOperand).dispose();
            }
            if (this.rightOperand instanceof IDisposable) {
                ((IDisposable)this.rightOperand).dispose();
            }
        }

        @Override
        public IStatus getStatus() {
            IStatus status = super.getStatus();
            if (status == null) {
                status = this.leftOperand.getStatus();
            }
            if (status == null) {
                status = this.rightOperand.getStatus();
            }
            return status;
        }

        protected static int getPromotionScore(Class<?> type) {
            int i = promotionTable.length;
            while (i-- > 0) {
                if (!type.equals(promotionTable[i])) continue;
                return i;
            }
            return -1;
        }

        protected abstract Object doBooleanOperation(Object var1, Object var2);

        protected abstract Object doNumericOperation(Object var1, Object var2);

        protected abstract Object doArrayOperation(Object var1, Object var2);

        protected abstract Object doStringOperation(Object var1, Object var2);

        @Override
        public Object getValue() {
            Object leftValue = this.leftOperand.getValue();
            Object rightValue = this.rightOperand.getValue();
            if (leftValue == null || rightValue == null) {
                return null;
            }
            Object result = this.doBooleanOperation(leftValue, rightValue);
            if (result == null) {
                result = this.doNumericOperation(leftValue, rightValue);
            }
            if (result == null) {
                result = this.doArrayOperation(leftValue, rightValue);
            }
            if (result == null) {
                result = this.doStringOperation(leftValue, rightValue);
            }
            if (result instanceof IStatus) {
                this.setStatus((IStatus)result);
                result = null;
            }
            return result;
        }

        @Override
        public boolean isStale() {
            return this.leftOperand.isStale() || this.rightOperand.isStale();
        }

        @Override
        public void addStaleListener(IStaleListener listener) {
            this.leftOperand.addStaleListener(listener);
            this.rightOperand.addStaleListener(listener);
        }

        @Override
        public void removeStaleListener(IStaleListener listener) {
            this.leftOperand.removeStaleListener(listener);
            this.rightOperand.removeStaleListener(listener);
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }

    static abstract class Factory<T extends IBindValue, V extends IUriElement<T>>
    implements IOperatorFactory<T, V> {
        private String operator;

        protected Factory(String operator) {
            this.operator = operator;
        }

        protected abstract AbstractBinaryOperator<T, V> createOperator();

        protected boolean allowWritable(V leftOperand, V rightOperand) {
            return false;
        }

        @Override
        public V parse(String uri, boolean readOnly, AbstractUriBinding.Factory<T, V> factory, int precedence, AbstractBindProvider backplane) throws UriParseException {
            int pos = factory.findLastIndexOf(uri, this.operator);
            if (pos > 0 && pos < uri.length() - 1) {
                String operandText = uri.substring(0, pos);
                Object leftOperand = factory.parseExpression(operandText.trim(), readOnly, precedence, backplane);
                operandText = uri.substring(pos + this.operator.length());
                Object rightOperand = factory.parseExpression(operandText.trim(), readOnly, precedence + 1, backplane);
                if (readOnly || this.allowWritable(leftOperand, rightOperand)) {
                    AbstractBinaryOperator<T, V> result = this.createOperator();
                    result.leftOperand = leftOperand;
                    result.rightOperand = rightOperand;
                    result.operator = this.operator;
                    return (V)result;
                }
                StringBuilder msg = new StringBuilder();
                msg.append("The '");
                msg.append(this.operator);
                msg.append("' operator is not allowed here.  You cannot use binary operators to bind read/write properties.");
                throw new UriParseException(msg.toString());
            }
            return null;
        }

        @Override
        public String getOperator() {
            return this.operator;
        }
    }
}

