/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.internal.bind.ErrorStatus;
import com.ti.backplane.internal.expressionParser.AbstractBinaryOperator;
import com.ti.backplane.internal.expressionParser.IUriElement;
import java.lang.reflect.Array;

abstract class AbstractComparisonOperator<T extends IBindValue, V extends IUriElement<T>>
extends AbstractBinaryOperator<T, V> {
    AbstractComparisonOperator() {
    }

    static abstract class Binding<T extends IBindValue>
    extends AbstractBinaryOperator.Binding<T> {
        Binding() {
        }

        @Override
        protected Object doBooleanOperation(Object leftValue, Object rightValue) {
            if (leftValue instanceof Boolean && rightValue instanceof Boolean) {
                if (this instanceof IBooleanOperator) {
                    return new Boolean(((IBooleanOperator)((Object)this)).getValue((Boolean)leftValue, (Boolean)rightValue));
                }
                return new ErrorStatus("Operator '" + this.getOperator() + "' does not support boolean types");
            }
            return null;
        }

        @Override
        protected Object doNumericOperation(Object leftValue, Object rightValue) {
            if (leftValue instanceof Number && rightValue instanceof Number) {
                int rightScore;
                int leftScore = Binding.getPromotionScore(leftValue.getClass());
                int resultScore = Math.min(leftScore, rightScore = Binding.getPromotionScore(rightValue.getClass()));
                if (resultScore < SCORE_DOUBLE) {
                    return new ErrorStatus("Operator '" + this.getOperator() + "' does not support numeric types");
                }
                if (resultScore < SCORE_LONG) {
                    if (this instanceof IDecimalOperator) {
                        return new Boolean(((IDecimalOperator)((Object)this)).getValue(((Number)leftValue).doubleValue(), ((Number)rightValue).doubleValue()));
                    }
                    return new ErrorStatus("Operator '" + this.getOperator() + "' does not support floating point types");
                }
                if (this instanceof IIntegerOperator) {
                    return new Boolean(((IIntegerOperator)((Object)this)).getValue(((Number)leftValue).longValue(), ((Number)rightValue).longValue()));
                }
                return new ErrorStatus("Operator '" + this.getOperator() + "' does not support integer types");
            }
            return null;
        }

        @Override
        protected Object doArrayOperation(Object leftValue, Object rightValue) {
            if (leftValue instanceof Object[] || rightValue instanceof Object[]) {
                if (this instanceof IArrayOperator) {
                    if (!(leftValue instanceof Object[])) {
                        Object result = Array.newInstance(leftValue.getClass(), 1);
                        Array.set(result, 0, leftValue);
                        return ((IArrayOperator)((Object)this)).getValue((Object[])result, (Object[])rightValue);
                    }
                    if (!(rightValue instanceof Object[])) {
                        Object result = Array.newInstance(rightValue.getClass(), 1);
                        Array.set(result, 0, rightValue);
                        return ((IArrayOperator)((Object)this)).getValue((Object[])leftValue, (Object[])result);
                    }
                    return ((IArrayOperator)((Object)this)).getValue((Object[])leftValue, (Object[])rightValue);
                }
                return new ErrorStatus("Operator '" + this.getOperator() + "' does not support array types");
            }
            return null;
        }

        @Override
        protected Object doStringOperation(Object leftValue, Object rightValue) {
            if (leftValue instanceof String && rightValue instanceof String) {
                if (this instanceof IStringOperator) {
                    return ((IStringOperator)((Object)this)).getValue(leftValue.toString(), rightValue.toString());
                }
                return new ErrorStatus("Operator '" + this.getOperator() + "' does not support string types");
            }
            if (this instanceof IStringOperator) {
                return ((IStringOperator)((Object)this)).getValue(leftValue.toString(), rightValue.toString());
            }
            String type = this.getTypeName(leftValue);
            if (type == null) {
                type = this.getTypeName(rightValue);
            }
            if (type == null) {
                type = "object";
            }
            return new ErrorStatus("Operator '" + this.getOperator() + "' does not support " + type + " types");
        }

        private String getTypeName(Object operand) {
            if (operand instanceof Object[] && !(this instanceof IArrayOperator)) {
                return "array";
            }
            if (operand instanceof String && !(this instanceof IStringOperator)) {
                return "string";
            }
            if (operand instanceof Boolean && !(this instanceof IBooleanOperator)) {
                return "boolean";
            }
            if (operand instanceof Number) {
                if (operand instanceof Double || operand instanceof Float) {
                    if (!(this instanceof IDecimalOperator)) {
                        return "decimal";
                    }
                } else if (!(this instanceof IIntegerOperator)) {
                    return "integer";
                }
            }
            return null;
        }

        @Override
        public Class<?> getType() {
            return Boolean.class;
        }
    }

    static abstract class Factory<T extends IBindValue, V extends IUriElement<T>>
    extends AbstractBinaryOperator.Factory<T, V> {
        protected Factory(String operator) {
            super(operator);
        }
    }

    protected static interface IArrayOperator {
        public boolean getValue(Object[] var1, Object[] var2);
    }

    protected static interface IBooleanOperator {
        public boolean getValue(boolean var1, boolean var2);
    }

    protected static interface IDecimalOperator {
        public boolean getValue(double var1, double var3);
    }

    protected static interface IIntegerOperator {
        public boolean getValue(long var1, long var3);
    }

    protected static interface IStringOperator {
        public boolean getValue(String var1, String var2);
    }
}

