/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.AbstractBind;
import com.ti.backplane.bind.AbstractBindProvider;
import com.ti.backplane.bind.IBindListener;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IChangedListener;
import com.ti.backplane.bind.IDisposable;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStaleListener;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.expressionParser.AbstractUriBinding;
import com.ti.backplane.internal.expressionParser.IBindingContext;
import com.ti.backplane.internal.expressionParser.IOperatorFactory;
import com.ti.backplane.internal.expressionParser.IUriElement;
import com.ti.backplane.internal.expressionParser.UriParseException;
import java.util.ArrayList;

abstract class AbstractFunctionOperator<T extends IBindValue, V extends IUriElement<T>>
implements IUriElement<T> {
    protected ArrayList<V> operands;
    protected String functionName;

    AbstractFunctionOperator() {
    }

    protected abstract Binding<T> createBinding(IBindingContext var1);

    @Override
    public T bind(IBindingContext context) {
        Binding<T> result = this.createBinding(context);
        if (this.operands != null) {
            result.operands = new ArrayList(this.operands.size());
            int i = 0;
            while (i < this.operands.size()) {
                result.operands.add((IBindValue)((IUriElement)this.operands.get(i)).bind(context));
                ++i;
            }
        }
        return (T)result;
    }

    @Override
    public String toOperandText() {
        StringBuilder result = new StringBuilder(this.functionName);
        boolean firstTime = true;
        if (this.operands != null) {
            for (IUriElement operand : this.operands) {
                if (!firstTime) {
                    result.append(", ");
                }
                result.append(operand.toOperandText());
                firstTime = false;
            }
        }
        result.append(')');
        return result.toString();
    }

    public String toString() {
        return "value:" + this.toOperandText();
    }

    static abstract class Binding<T extends IBindValue>
    extends AbstractBind
    implements IBindValue,
    IDisposable {
        protected ArrayList<T> operands;

        Binding() {
        }

        protected abstract String getFunctionName();

        protected String getOperator() {
            return String.valueOf(this.getFunctionName()) + "()";
        }

        @Override
        public void addChangedListener(IChangedListener listener) {
            if (this.operands != null) {
                for (IBindValue operand : this.operands) {
                    operand.addChangedListener(listener);
                }
            }
        }

        @Override
        public void removeChangedListener(IChangedListener listener) {
            if (this.operands != null) {
                for (IBindValue operand : this.operands) {
                    operand.removeChangedListener(listener);
                }
            }
        }

        @Override
        public IStatus getStatus() {
            IStatus result = super.getStatus();
            if (result == null && this.operands != null) {
                for (IBindValue operand : this.operands) {
                    result = operand.getStatus();
                    if (result != null) break;
                }
            }
            return result;
        }

        @Override
        public void addBindListener(IBindListener listener) {
            super.addBindListener(listener);
            if (this.operands != null) {
                for (IBindValue operand : this.operands) {
                    operand.addBindListener(listener);
                }
            }
        }

        @Override
        public void removeBindListener(IBindListener listener) {
            super.removeBindListener(listener);
            if (this.operands != null) {
                for (IBindValue operand : this.operands) {
                    operand.removeBindListener(listener);
                }
            }
        }

        @Override
        public void dispose() {
            if (this.operands != null) {
                for (IBindValue operand : this.operands) {
                    if (!(operand instanceof IDisposable)) continue;
                    ((IDisposable)((Object)operand)).dispose();
                }
            }
        }

        @Override
        public void setValue(Object value, IFinished callback) {
            callback.done(null);
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.getFunctionName());
            result.append('(');
            boolean firstTime = true;
            if (this.operands != null) {
                for (IBindValue operand : this.operands) {
                    if (!firstTime) {
                        result.append(", ");
                    }
                    result.append(operand.toString());
                    firstTime = false;
                }
            }
            result.append(')');
            return result.toString();
        }

        @Override
        public boolean isStale() {
            if (this.operands != null) {
                for (IBindValue operand : this.operands) {
                    if (!operand.isStale()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void addStaleListener(IStaleListener listener) {
            if (this.operands != null) {
                for (IBindValue operand : this.operands) {
                    operand.addStaleListener(listener);
                }
            }
        }

        @Override
        public void removeStaleListener(IStaleListener listener) {
            if (this.operands != null) {
                for (IBindValue operand : this.operands) {
                    operand.removeStaleListener(listener);
                }
            }
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }

    static abstract class Factory<T extends IBindValue, V extends IUriElement<T>>
    implements IOperatorFactory<T, V> {
        private String functionName;
        private int numParameters;

        protected Factory(String functionName, int numParams) {
            this.functionName = String.valueOf(functionName) + "(";
            this.numParameters = numParams;
        }

        protected abstract AbstractFunctionOperator<T, V> createOperator();

        @Override
        public V parse(String uri, boolean readOnly, AbstractUriBinding.Factory<T, V> factory, int precedence, AbstractBindProvider backplane) throws UriParseException {
            if (uri.startsWith(this.functionName)) {
                if (uri.endsWith(")")) {
                    if (!readOnly) {
                        Factory.composeReadOnlyErrMsg(this.functionName);
                    }
                    String operandText = uri.substring(this.functionName.length(), uri.length() - 1);
                    ArrayList<Object> operands = this.numParameters > 0 ? new ArrayList<Object>(this.numParameters) : null;
                    int i = this.numParameters;
                    while (i-- > 0) {
                        String param = operandText;
                        int pos = factory.findLastIndexOf(param, ",");
                        if (pos > 0 && pos < param.length() - 1) {
                            if (i == 0) {
                                Factory.composeTooManyParametersErrMsg(this.functionName, this.numParameters);
                            }
                            param = param.substring(pos + 1);
                            operandText = operandText.substring(0, pos);
                        } else if (i > 0) {
                            Factory.composeMissingFunctionParameterErrMsg(this.functionName, this.numParameters, this.numParameters - i);
                        }
                        Object operand = factory.parseExpression(param.trim(), readOnly, 0, backplane);
                        if (operand != null) {
                            operands.add(0, operand);
                            continue;
                        }
                        Factory.composeMissingFunctionParameterErrMsg(this.functionName, this.numParameters, this.numParameters - i);
                    }
                    operandText = operandText.trim();
                    if (this.numParameters == 0 && operandText.length() > 0) {
                        Factory.composeTooManyParametersErrMsg(this.functionName, this.numParameters);
                    }
                    AbstractFunctionOperator<T, V> result = this.createOperator();
                    result.functionName = this.functionName;
                    result.operands = operands;
                    return (V)result;
                }
                int pos = uri.lastIndexOf(")");
                if (pos < 0) {
                    AbstractUriBinding.Factory.composeMissingClosingBraceErrMsg(uri, "a ')' closing parenthesis");
                } else {
                    AbstractUriBinding.Factory.composeMissingOperatorErrMsg(uri.substring(pos + 1));
                }
            }
            return null;
        }

        private static void composeReadOnlyErrMsg(String functionName) throws UriParseException {
            StringBuilder msg = new StringBuilder();
            msg.append("The '");
            msg.append(functionName);
            msg.append(")' function is not allowed here.  You cannot use function calls to bind read/write properties.");
            throw new UriParseException(msg.toString());
        }

        private static void composeMissingFunctionParameterErrMsg(String functionName, int expectedParams, int actualParams) throws UriParseException {
            StringBuilder msg = new StringBuilder();
            msg.append("To be honest, I was expecting the function \"");
            msg.append(functionName);
            msg.append(")\" to have ");
            msg.append(expectedParams);
            msg.append(" parameters, but I only found ");
            msg.append(actualParams);
            msg.append(".");
            throw new UriParseException(msg.toString());
        }

        private static void composeTooManyParametersErrMsg(String functionName, int expectedParams) throws UriParseException {
            StringBuilder msg = new StringBuilder();
            msg.append("To be honest, I was expecting the function \"");
            msg.append(functionName);
            msg.append(")\" to have ");
            msg.append(expectedParams);
            msg.append(" parameters, but I found too many.");
            throw new UriParseException(msg.toString());
        }

        @Override
        public String getOperator() {
            return this.functionName;
        }
    }
}

