/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.AbstractBindValue;
import com.ti.backplane.bind.AbstractStatus;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindListener;
import com.ti.backplane.bind.IBindProvider;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IChangedListener;
import com.ti.backplane.bind.IDisposable;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStaleListener;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.ErrorStatus;
import com.ti.backplane.internal.dataconversion.DataConverter;
import com.ti.backplane.internal.datatypes.ITypeSafeLookup;
import com.ti.backplane.internal.expressionParser.DotOperator;
import com.ti.backplane.internal.expressionParser.IBindingContext;
import com.ti.backplane.internal.expressionParser.IUriValue;
import com.ti.backplane.internal.expressionParser.Uninitialized;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

abstract class AbstractLookupOperator
implements IUriValue {
    private IUriValue leftOperand;

    protected abstract Binding createBinding();

    protected AbstractLookupOperator(IUriValue leftoperand) {
        this.leftOperand = leftoperand;
    }

    @Override
    public IBindValue bind(IBindingContext context) {
        Binding result = this.createBinding();
        result.leftOperand = (IBindValue)this.leftOperand.bind(context);
        return result;
    }

    @Override
    public String toOperandText() {
        StringBuilder text = new StringBuilder();
        text.append(this.leftOperand.toOperandText());
        return text.toString();
    }

    public String toString() {
        return "value:" + this.toOperandText();
    }

    protected static abstract class Binding
    extends AbstractBindValue
    implements IBindValue,
    IChangedListener,
    IDisposable,
    IBindListener,
    IStaleListener {
        private IBindValue leftOperand;
        private IBindValue lookupBinding;
        private LookupBindingChangeListener lookupBindingListener;
        private Object cachedLeftValue = NotCached.value;
        private DataConverter lookupKeyConverter = new DataConverter();
        private IStatus localStatus = null;

        protected Binding() {
            super(null);
        }

        public Binding(IBindValue lValue) {
            super(null);
            this.leftOperand = lValue;
        }

        @Override
        protected void onFirstChangeListenerAdded() {
            super.onFirstChangeListenerAdded();
            if (this.leftOperand != null) {
                this.leftOperand.addChangedListener(this);
                this.cachedLeftValue = Uninitialized.value;
            }
        }

        @Override
        protected void onLastChangedListenerRemoved() {
            super.onLastChangedListenerRemoved();
            if (this.leftOperand != null) {
                this.leftOperand.removeChangedListener(this);
                this.cachedLeftValue = NotCached.value;
            }
            if (this.lookupBinding != null) {
                this.lookupBinding.removeChangedListener(this.lookupBindingListener);
                this.lookupBinding.removeBindListener(this);
                this.lookupBinding.removeStaleListener(this);
                this.lookupBinding = null;
            }
        }

        @Override
        public void addBindListener(IBindListener listener) {
            super.addBindListener(listener);
            if (this.leftOperand != null) {
                this.leftOperand.addBindListener(this);
            }
        }

        @Override
        public void removeBindListener(IBindListener listener) {
            super.removeBindListener(listener);
            if (this.leftOperand != null) {
                this.leftOperand.removeBindListener(this);
            }
        }

        @Override
        protected void onLastBindListenerRemoved() {
            super.onLastBindListenerRemoved();
            if (this.lookupBinding != null) {
                this.lookupBinding.removeBindListener(this);
            }
        }

        @Override
        protected void onFirstBindListenerAdded() {
            super.onFirstBindListenerAdded();
            if (this.lookupBinding != null) {
                this.lookupBinding.addBindListener(this);
            }
        }

        @Override
        public void dispose() {
            if (this.leftOperand != null && this.leftOperand instanceof IDisposable) {
                ((IDisposable)((Object)this.leftOperand)).dispose();
            }
        }

        private void updateStatus() {
            IStatus status = this.localStatus;
            if (status == null) {
                if (this.lookupBinding != null) {
                    status = this.lookupBinding.getStatus();
                } else if (this.leftOperand != null) {
                    status = this.leftOperand.getStatus();
                }
            }
            this.setStatus(status);
        }

        public void onValueChanged(boolean notifyChange, IFinished callback) {
            this.getLookupBinding(new IStatus[1]);
            if (this.lookupBinding != null) {
                this.lookupBinding.removeChangedListener(this.lookupBindingListener);
                this.lookupBinding.removeBindListener(this);
                this.lookupBinding.removeStaleListener(this);
                this.lookupBinding = null;
                this.cachedLeftValue = Uninitialized.value;
                this.notifyChangedListeners(callback);
            } else {
                Object leftValue;
                Object object = leftValue = this.leftOperand == null ? null : this.leftOperand.getValue();
                if (leftValue != this.cachedLeftValue) {
                    this.cachedLeftValue = leftValue;
                    notifyChange = true;
                }
                if (notifyChange) {
                    this.notifyChangedListeners(callback);
                } else {
                    callback.done(null);
                }
            }
        }

        @Override
        public void onStatusChanged(IStatus status) {
            this.updateStatus();
        }

        protected IBindValue getLookupBinding(Object key, IStatus[] status) {
            if (this.lookupBinding == null) {
                IBindValue leftLookupBinding = this.leftOperand;
                if (this.leftOperand instanceof Binding) {
                    leftLookupBinding = ((Binding)this.leftOperand).getLookupBinding(status);
                }
                if (leftLookupBinding instanceof IBindProvider) {
                    if (key == null) {
                        status[0] = AbstractStatus.createErrorStatus("The index value is null.");
                    } else {
                        key = this.lookupKeyConverter.convert(key.getClass(), String.class, key, null, status);
                        if (status[0] == null) {
                            IBind result = ((IBindProvider)((Object)leftLookupBinding)).getBinding((String)key);
                            if (result != null && result instanceof IBindValue) {
                                this.lookupBinding = (IBindValue)result;
                                if (this.lookupBindingListener == null) {
                                    this.lookupBindingListener = new LookupBindingChangeListener();
                                }
                                this.lookupBinding.addBindListener(this);
                                this.lookupBinding.addChangedListener(this.lookupBindingListener);
                                if (this.hasStaleListeners()) {
                                    this.lookupBinding.addStaleListener(this);
                                }
                            } else {
                                status[0] = this instanceof DotOperator.Binding ? AbstractStatus.createErrorStatus("Dot operator failed because the element named '" + (String)key + "' was not found") : AbstractStatus.createErrorStatus("The index '" + (String)key + "' cannot be found.");
                            }
                        }
                    }
                }
            }
            return this.lookupBinding;
        }

        protected abstract IBindValue getLookupBinding(IStatus[] var1);

        protected Object getValue(Object key) {
            IStatus[] status = new IStatus[1];
            Object result = null;
            this.getLookupBinding(key, status);
            if (this.lookupBinding != null) {
                result = this.lookupBinding.getValue();
            } else if (status[0] == null) {
                Object leftValue = null;
                if (this.leftOperand != null) {
                    if (this.cachedLeftValue == Uninitialized.value) {
                        this.cachedLeftValue = this.leftOperand == null ? null : this.leftOperand.getValue();
                    }
                    Object object = leftValue = this.cachedLeftValue == NotCached.value ? this.leftOperand.getValue() : this.cachedLeftValue;
                }
                if (leftValue != null) {
                    if (key == null) {
                        status[0] = AbstractStatus.createErrorStatus("The index value is null.");
                    } else if (leftValue instanceof ITypeSafeLookup) {
                        key = this.lookupKeyConverter.convert(key.getClass(), ((ITypeSafeLookup)leftValue).getKeyType(), key, null, status);
                        if (status[0] == null) {
                            result = ((ITypeSafeLookup)leftValue).getValue(key);
                        }
                    } else if (leftValue instanceof Map) {
                        result = ((Map)leftValue).get(key);
                        if (result == null) {
                            status[0] = AbstractStatus.createErrorStatus("The index '" + key.toString() + "' was not found.");
                        }
                    } else {
                        key = this.lookupKeyConverter.convert(key.getClass(), Integer.class, key, null, status);
                        if (status[0] != null) {
                            status[0] = AbstractStatus.createErrorStatus("The index is not valid: " + status[0].getMessage());
                        } else {
                            int size;
                            int index = ((Number)key).intValue();
                            int n = leftValue instanceof Collection ? ((Collection)leftValue).size() : (size = leftValue instanceof Object[] ? ((Object[])leftValue).length : 1);
                            if (index < 0 || index >= size) {
                                status[0] = new ErrorStatus("The index " + index + " is out of bounds.  It must be between 0 and " + size);
                            } else if (leftValue instanceof List) {
                                result = ((List)leftValue).get(index);
                            } else if (leftValue instanceof Collection) {
                                Iterator it = ((Collection)leftValue).iterator();
                                while (index-- > 0) {
                                    it.next();
                                }
                                result = it.next();
                            } else {
                                result = leftValue instanceof Object[] ? ((Object[])leftValue)[index] : leftValue;
                            }
                        }
                    }
                }
            }
            this.localStatus = status[0];
            this.updateStatus();
            return result;
        }

        protected void setValue(Object key, Object value, IFinished callback) {
            IStatus[] status = new IStatus[1];
            this.getLookupBinding(key, status);
            if (this.lookupBinding != null) {
                this.lookupBinding.setValue(value, callback);
            } else if (status[0] == null) {
                Object leftValue = null;
                if (this.leftOperand != null) {
                    if (this.cachedLeftValue == Uninitialized.value) {
                        this.cachedLeftValue = this.leftOperand == null ? null : this.leftOperand.getValue();
                    }
                    Object object = leftValue = this.cachedLeftValue == NotCached.value ? this.leftOperand.getValue() : this.cachedLeftValue;
                }
                if (leftValue != null) {
                    if (key == null) {
                        status[0] = AbstractStatus.createErrorStatus("The index value is null.");
                    } else if (leftValue instanceof ITypeSafeLookup) {
                        key = this.lookupKeyConverter.convert(key.getClass(), ((ITypeSafeLookup)leftValue).getKeyType(), key, null, status);
                        if (status[0] == null) {
                            if (value.getClass().isAssignableFrom(((ITypeSafeLookup)leftValue).getValueType())) {
                                ((ITypeSafeLookup)leftValue).setValue(key, value);
                            } else {
                                status[0] = new ErrorStatus("Cannot set the array element value because the types do not match");
                            }
                        }
                    } else if (leftValue instanceof Collection || leftValue instanceof Map) {
                        status[0] = new ErrorStatus("Elements in Collections and Maps are read-only and cannot be changed.");
                    } else {
                        key = this.lookupKeyConverter.convert(key.getClass(), Number.class, key, null, status);
                        if (status[0] == null) {
                            int size;
                            int index = ((Number)key).intValue();
                            int n = size = leftValue instanceof Object[] ? ((Object[])leftValue).length : 1;
                            if (index < 0 || index >= size) {
                                status[0] = new ErrorStatus("The index " + index + " is out of bounds.  It must be between 0 and " + size);
                            } else if (leftValue instanceof Object[]) {
                                ((Object[])leftValue)[index] = value;
                            } else {
                                this.leftOperand.setValue(value, callback);
                            }
                        }
                    }
                }
            }
            this.localStatus = status[0];
            this.updateStatus();
            if (callback != null) {
                callback.done(this.getStatus());
            }
        }

        @Override
        public String toString() {
            return this.leftOperand.toString();
        }

        protected boolean isStale(Object key) {
            IStatus[] status = new IStatus[1];
            this.getLookupBinding(key, status);
            if (this.lookupBinding != null) {
                return this.lookupBinding.isStale();
            }
            if (status[0] == null && this.leftOperand != null) {
                return this.leftOperand.isStale();
            }
            return false;
        }

        protected boolean isReadOnly(Object key) {
            IStatus[] status = new IStatus[1];
            this.getLookupBinding(key, status);
            if (this.lookupBinding != null) {
                return this.lookupBinding.isReadOnly();
            }
            if (status[0] == null && this.leftOperand != null) {
                return this.leftOperand.isReadOnly();
            }
            return true;
        }

        @Override
        protected void onFirstStaleListenerAdded() {
            super.onFirstStaleListenerAdded();
            if (this.leftOperand != null) {
                this.leftOperand.addStaleListener(this);
            }
            if (this.lookupBinding != null) {
                this.lookupBinding.addStaleListener(this);
            }
        }

        @Override
        protected void onLastStaleListenerRemoved() {
            super.onLastStaleListenerRemoved();
            if (this.leftOperand != null) {
                this.leftOperand.removeStaleListener(this);
            }
            if (this.lookupBinding != null) {
                this.lookupBinding.removeStaleListener(this);
            }
        }

        @Override
        public void onStaleChanged() {
            this.notifyStaleListeners();
        }

        private class LookupBindingChangeListener
        implements IChangedListener {
            private LookupBindingChangeListener() {
            }

            @Override
            public void onValueChanged(IFinished callback) {
                Binding.this.notifyChangedListeners(callback);
            }
        }
    }

    protected static class ElementIsReadOnly
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected ElementIsReadOnly() {
        }
    }

    protected static class NotCached {
        protected static NotCached value = new NotCached();

        protected NotCached() {
        }

        public String toString() {
            return "not cached";
        }
    }
}

