/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.AbstractBindProvider;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.internal.expressionParser.IOperatorFactory;
import com.ti.backplane.internal.expressionParser.IUriBindingFactory;
import com.ti.backplane.internal.expressionParser.IUriElement;
import com.ti.backplane.internal.expressionParser.IUriValue;
import com.ti.backplane.internal.expressionParser.UriParseException;
import com.ti.backplane.internal.expressionParser.UriUtility;
import java.util.ArrayList;

abstract class AbstractUriBinding<T extends IBind>
implements IUriElement<T> {
    protected String identifier;

    public AbstractUriBinding(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public String toOperandText() {
        return this.identifier;
    }

    public String toString() {
        return "value:" + this.identifier;
    }

    public void dispose() {
    }

    public static abstract class Factory<T extends IBind, V extends IUriElement<T>>
    implements IUriBindingFactory<V> {
        private ArrayList<IOperatorFactory<T, V>> operatorFactories = new ArrayList();
        private Bracket brackets = new Bracket("(", ")", null);

        protected void addOperatorFactory(IOperatorFactory<T, V> factory) {
            this.operatorFactories.add(factory);
        }

        protected void addBraces(String openingBrace, String closingBrace) {
            this.brackets.link = new Bracket(openingBrace, closingBrace, this.brackets.link);
        }

        boolean isOperatorInAnyBrackets(String leftOperand, int endingPos) {
            return this.brackets == null ? false : this.brackets.isInBracket(leftOperand, endingPos);
        }

        protected abstract V parseLiteral(String var1) throws UriParseException;

        protected V parseLiteralOperand(String operand) throws UriParseException {
            return this.parseLiteral(operand);
        }

        @Override
        public V parseUri(String uri, boolean readOnly, AbstractBindProvider backplane) throws UriParseException {
            if (uri == null || uri.length() == 0) {
                return null;
            }
            if (UriUtility.isValue(uri)) {
                return (V)this.parseExpression(UriUtility.getPath(uri).trim(), readOnly, 0, backplane);
            }
            return this.parseLiteral(uri);
        }

        private V parseParentheses(String uri, boolean readOnly, AbstractBindProvider backplane) throws UriParseException {
            if (uri.startsWith("(")) {
                if (uri.endsWith(")")) {
                    String param = uri.substring(1, uri.length() - 1);
                    return (V)this.parseExpression(param.trim(), readOnly, 0, backplane);
                }
                int pos = uri.lastIndexOf(")");
                if (pos < 0) {
                    Factory.composeMissingClosingBraceErrMsg(uri, "')' parenthesis");
                } else {
                    Factory.composeMissingOperatorErrMsg(uri.substring(pos + 1));
                }
            }
            return null;
        }

        @Override
        public V parseExpression(String uri, boolean readOnly, int precedence, AbstractBindProvider backplane) throws UriParseException {
            String unrecognizedText;
            V result = null;
            boolean isLiteral = Character.isDigit(uri.charAt(0));
            String string = unrecognizedText = isLiteral ? null : this.parseIdentifier(uri);
            if (unrecognizedText != null || isLiteral) {
                int i = precedence;
                while (i < this.operatorFactories.size()) {
                    IOperatorFactory<T, V> factory = this.operatorFactories.get(i);
                    result = factory.parse(uri, readOnly, this, i, backplane);
                    if (result != null) break;
                    ++i;
                }
                if (result == null) {
                    result = this.parseParentheses(uri, readOnly, backplane);
                }
            }
            String literalErrorMessage = null;
            if (result == null) {
                try {
                    result = this.parseLiteralOperand(uri);
                }
                catch (UriParseException e) {
                    if (isLiteral) {
                        throw e;
                    }
                    literalErrorMessage = e.getLocalizedMessage();
                }
            }
            if (result == null) {
                if (unrecognizedText == null) {
                    result = this.bindValue(uri);
                } else {
                    this.composeUnrecognizedIdentifier(unrecognizedText, literalErrorMessage);
                }
            }
            return result;
        }

        protected abstract V bindValue(String var1);

        private String parseIdentifier(String uri) {
            int i = 0;
            while (i < uri.length()) {
                char ch = uri.charAt(i);
                if (!Character.isJavaIdentifierPart(ch) && ch != '\'' && ch != '.') {
                    StringBuilder unrecognizedText = new StringBuilder(ch);
                    while (i < uri.length()) {
                        ch = uri.charAt(i);
                        if (Character.isJavaIdentifierPart(ch) || ch == '\'' || ch == '.') break;
                        unrecognizedText.append(ch);
                        ++i;
                    }
                    return unrecognizedText.toString();
                }
                ++i;
            }
            return null;
        }

        private void composeUnrecognizedIdentifier(String unrecognizedText, String literalErrorMessage) throws UriParseException {
            if (unrecognizedText.trim().length() == 0) {
                Factory.composeUnexpectedWhiteSpaceErrMsg(unrecognizedText);
            } else {
                this.composeUnrecognizedTextErrMsg(unrecognizedText, literalErrorMessage);
            }
        }

        int findFirstIndexOf(String text, String operator, int startingPos) {
            int pos = startingPos;
            while ((pos = text.indexOf(operator, pos)) > 0 && this.isOperatorInAnyBrackets(text, pos - 1)) {
                if ((pos += operator.length()) < text.length()) continue;
                pos = -1;
                break;
            }
            return pos;
        }

        int findLastIndexOf(String text, String operator) {
            int pos = text.lastIndexOf(operator);
            while (pos > 0 && this.isOperatorInAnyBrackets(text, pos - 1)) {
                pos = text.lastIndexOf(operator, pos - operator.length());
            }
            return pos;
        }

        int findMatchingBrace(String text, String openingBrace, String closingBrace) {
            int pos = -1;
            int nestedBracePos = -1;
            do {
                pos = this.findFirstIndexOf(text, closingBrace, pos + 1);
            } while ((nestedBracePos = this.findFirstIndexOf(text, openingBrace, nestedBracePos + 1)) >= 0 && pos > nestedBracePos);
            return pos;
        }

        static String composeUnexpectedWhiteSpaceErrMsg(String text) throws UriParseException {
            StringBuilder msg = new StringBuilder();
            msg.append("Unexpected white space was found in the following expression \"");
            msg.append(text);
            msg.append("\".  To be honest, I was expecting an operator, or something other than blank.");
            throw new UriParseException(msg.toString());
        }

        private void composeUnrecognizedTextErrMsg(String text, String literalErrorMessage) throws UriParseException {
            StringBuilder msg = new StringBuilder();
            msg.append("Unexpected character");
            if (text.length() > 1) {
                msg.append("s \"");
                msg.append(text);
                msg.append("\" were");
            } else {
                msg.append(" '");
                msg.append(text);
                msg.append("' was");
            }
            msg.append(" found.  If this was suppose to be an operator, it is not supported.");
            if (literalErrorMessage != null) {
                msg.append("  Also, I do not recognize this as part of a literal.  ");
                msg.append(literalErrorMessage);
            }
            throw new UriParseException(msg.toString());
        }

        static void composeMissingOperatorErrMsg(String uri) throws UriParseException {
            StringBuilder msg = new StringBuilder();
            msg.append("To be honest, I was expecting to find an operator at the beginning of this expression: ");
            msg.append(uri);
            throw new UriParseException(msg.toString());
        }

        static void composeMissingClosingBraceErrMsg(String uri, String brace) throws UriParseException {
            StringBuilder msg = new StringBuilder();
            msg.append("To be honest, I was expecting to find a terminating ");
            msg.append(brace);
            msg.append(" after \"");
            msg.append(uri);
            msg.append("\".");
            throw new UriParseException(msg.toString());
        }

        public IUriValue registerSubExpression(IUriValue operand, String uri, AbstractBindProvider backplane) throws UriParseException {
            return operand;
        }

        private static class Bracket {
            private String openingBrace;
            private String closingBrace;
            private Bracket link;

            Bracket(String opening, String closing, Bracket next) {
                this.openingBrace = opening;
                this.closingBrace = closing;
                this.link = next;
            }

            boolean isInBracket(String leftOperand, int endingPos) {
                int count = this.countBraces(leftOperand, this.openingBrace, endingPos);
                if (count > 0) {
                    if (this.closingBrace.compareTo(this.openingBrace) != 0) {
                        return (count -= this.countBraces(leftOperand, this.closingBrace, endingPos)) != 0;
                    }
                    if ((count & 1) != 0) {
                        return true;
                    }
                }
                if (this.link != null) {
                    return this.link.isInBracket(leftOperand, endingPos);
                }
                return false;
            }

            private int countBraces(String leftOperand, String brace, int endingPos) {
                int count = 0;
                int pos = 0;
                while (pos <= endingPos) {
                    if ((pos = leftOperand.indexOf(brace, pos)) < 0 || pos > endingPos) break;
                    if (pos == 0 || leftOperand.charAt(pos - 1) != '\\' && (this.link == null || !this.link.isInBracket(leftOperand, pos))) {
                        ++count;
                    }
                    pos += brace.length();
                }
                return count;
            }
        }
    }
}

