/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.internal.expressionParser.BinaryOperator;
import com.ti.backplane.internal.expressionParser.IOperatorFactory;
import com.ti.backplane.internal.expressionParser.IUriValue;
import java.lang.reflect.Array;

class AdditionOperator
extends BinaryOperator<IBindValue, IUriValue>
implements IUriValue {
    private static final String OP = "+";
    static IOperatorFactory<IBindValue, IUriValue> factory = new Factory();

    AdditionOperator() {
    }

    @Override
    protected BinaryOperator.Binding<IBindValue> createBinding() {
        return new Binding();
    }

    private static class Binding
    extends BinaryOperator.Binding<IBindValue>
    implements BinaryOperator.IIntegerOperator,
    BinaryOperator.IDecimalOperator,
    BinaryOperator.IStringOperator,
    BinaryOperator.IArrayOperator {
        private Binding() {
        }

        @Override
        public Object[] getValue(Object[] left, Object[] right) {
            if (left.length == 0) {
                return right;
            }
            if (right.length == 0) {
                return left;
            }
            Object result = Array.newInstance(left[0].getClass(), left.length + right.length);
            int i = right.length;
            while (i-- > 0) {
                Array.set(result, i + left.length, right[i]);
            }
            i = left.length;
            while (i-- > 0) {
                Array.set(result, i, left[i]);
            }
            return (Object[])result;
        }

        @Override
        public String getValue(String left, String right) {
            return String.valueOf(left) + right;
        }

        @Override
        public double getValue(double left, double right) {
            return left + right;
        }

        @Override
        public long getValue(long left, long right) {
            return left + right;
        }

        @Override
        protected String getOperator() {
            return AdditionOperator.OP;
        }
    }

    private static class Factory
    extends BinaryOperator.Factory<IBindValue, IUriValue> {
        private Factory() {
            super(AdditionOperator.OP);
        }

        @Override
        protected BinaryOperator<IBindValue, IUriValue> createOperator() {
            return new AdditionOperator();
        }
    }
}

