/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.internal.expressionParser.AbstractLiteralBinding;
import com.ti.backplane.internal.expressionParser.BooleanLiteral;
import com.ti.backplane.internal.expressionParser.IUriValue;
import com.ti.backplane.internal.expressionParser.NumberLiteral;
import com.ti.backplane.internal.expressionParser.UriParseException;
import com.ti.backplane.internal.expressionParser.UriUtility;
import java.text.NumberFormat;
import java.util.ArrayList;

class ArrayLiteral<T>
extends AbstractLiteralBinding<T[], IBindValue>
implements IBindValue,
IUriValue {
    public static final String openingCurlyBracket = "{";
    public static final String closingCurlyBracket = "}";
    private String protocol = "literal:";

    public ArrayLiteral(T[] valueArray) {
        this.literalValue = valueArray;
    }

    @Override
    public String toOperandText() {
        return openingCurlyBracket + this.toLiteralString() + closingCurlyBracket;
    }

    private String toLiteralString() {
        StringBuilder text = new StringBuilder();
        Object[] objectArray = (Object[])this.literalValue;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object literal = objectArray[n2];
            text.append(literal.toString());
            text.append(';');
            ++n2;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    @Override
    public String toString() {
        return String.valueOf(this.protocol) + this.toLiteralString();
    }

    public static ArrayLiteral<?> parse(String uri) throws UriParseException {
        String[] values = uri.split(";");
        if (values != null && values.length < 2) {
            return null;
        }
        ArrayList<Long> integerLiterals = new ArrayList<Long>(values.length);
        ArrayList<Double> decimalLiterals = new ArrayList<Double>(values.length);
        ArrayList<String> stringLiterals = new ArrayList<String>(values.length);
        ArrayList<Boolean> booleanLiterals = new ArrayList<Boolean>(values.length);
        NumberFormat nf = NumberFormat.getInstance();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if ((value = value.trim()).length() > 0) {
                stringLiterals.add(value);
                if (booleanLiterals != null) {
                    Boolean booleanLiteral = BooleanLiteral.parse(value);
                    if (booleanLiteral != null) {
                        booleanLiterals.add(booleanLiteral);
                    } else {
                        booleanLiterals = null;
                    }
                }
                if (decimalLiterals != null) {
                    Number result = NumberLiteral.parse(value, nf);
                    if (result == null) {
                        integerLiterals = null;
                        decimalLiterals = null;
                    } else if (result instanceof Double) {
                        integerLiterals = null;
                        decimalLiterals.add((Double)result);
                    } else {
                        if (integerLiterals != null) {
                            integerLiterals.add((Long)result);
                        }
                        decimalLiterals.add(new Double(result.doubleValue()));
                    }
                }
            }
            ++n2;
        }
        if (integerLiterals != null) {
            return new ArrayLiteral<Long>(integerLiterals.toArray(new Long[integerLiterals.size()]));
        }
        if (decimalLiterals != null) {
            return new ArrayLiteral<Double>(decimalLiterals.toArray(new Double[decimalLiterals.size()]));
        }
        if (booleanLiterals != null) {
            return new ArrayLiteral<Boolean>(booleanLiterals.toArray(new Boolean[booleanLiterals.size()]));
        }
        return new ArrayLiteral<String>(stringLiterals.toArray(new String[stringLiterals.size()]));
    }

    public static ArrayLiteral<?> parseLiteral(String uri) throws UriParseException {
        ArrayLiteral<?> result = ArrayLiteral.parse(UriUtility.getPath(uri));
        if (result != null && UriUtility.isURI(uri)) {
            result.protocol = UriUtility.getProtocol(uri);
        }
        return result;
    }

    public static ArrayLiteral<?> parseLiteralOperand(String uri) throws UriParseException {
        if (uri.startsWith(openingCurlyBracket) && uri.endsWith(closingCurlyBracket)) {
            uri = uri.substring(1, uri.length() - 1);
            return ArrayLiteral.parse(uri);
        }
        return null;
    }
}

