/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.AbstractBindProvider;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IDisposable;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.expressionParser.AbstractLookupOperator;
import com.ti.backplane.internal.expressionParser.AbstractUriBinding;
import com.ti.backplane.internal.expressionParser.DotOperator;
import com.ti.backplane.internal.expressionParser.IBindingContext;
import com.ti.backplane.internal.expressionParser.IOperatorFactory;
import com.ti.backplane.internal.expressionParser.IUriValue;
import com.ti.backplane.internal.expressionParser.Uninitialized;
import com.ti.backplane.internal.expressionParser.UriParseException;

public class ArrayOperator
extends AbstractLookupOperator {
    protected IUriValue indexOperand;
    static Factory factory = new Factory();

    public ArrayOperator(IUriValue leftOperand) {
        super(leftOperand);
    }

    @Override
    protected Binding createBinding() {
        return new Binding();
    }

    @Override
    public IBindValue bind(IBindingContext context) {
        Binding result = (Binding)super.bind(context);
        result.indexOperand = (IBindValue)this.indexOperand.bind(context);
        return result;
    }

    @Override
    public String toOperandText() {
        StringBuilder text = new StringBuilder();
        text.append(super.toOperandText());
        text.append("[");
        text.append(this.indexOperand.toOperandText());
        text.append("]");
        return text.toString();
    }

    protected static class Binding
    extends AbstractLookupOperator.Binding {
        private IBindValue indexOperand;
        private Object cachedIndexValue = AbstractLookupOperator.NotCached.value;

        protected Binding() {
        }

        @Override
        protected void onFirstChangeListenerAdded() {
            super.onFirstChangeListenerAdded();
            if (this.indexOperand != null) {
                this.indexOperand.addChangedListener(this);
                this.cachedIndexValue = Uninitialized.value;
            }
        }

        @Override
        protected void onLastChangedListenerRemoved() {
            super.onLastChangedListenerRemoved();
            if (this.indexOperand != null) {
                this.indexOperand.removeChangedListener(this);
                this.cachedIndexValue = AbstractLookupOperator.NotCached.value;
            }
        }

        @Override
        protected void onFirstBindListenerAdded() {
            super.onFirstBindListenerAdded();
            if (this.indexOperand != null) {
                this.indexOperand.addBindListener(this);
            }
        }

        @Override
        protected void onLastBindListenerRemoved() {
            super.onLastBindListenerRemoved();
            if (this.indexOperand != null) {
                this.indexOperand.removeBindListener(this);
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this.indexOperand != null && this.indexOperand instanceof IDisposable) {
                ((IDisposable)((Object)this.indexOperand)).dispose();
            }
        }

        @Override
        public Object getValue() {
            return super.getValue(this.getIndexValue());
        }

        @Override
        protected IBindValue getLookupBinding(IStatus[] status) {
            return super.getLookupBinding(this.getIndexValue(), status);
        }

        @Override
        public void setValue(Object value, IFinished callback) {
            super.setValue(this.getIndexValue(), value, callback);
        }

        @Override
        public Class<?> getType() {
            Object value = this.getValue(this.getIndexValue());
            return value == null ? String.class : value.getClass();
        }

        @Override
        public IStatus getStatus() {
            IStatus status = super.getStatus();
            if (status == null && this.indexOperand != null) {
                status = this.indexOperand.getStatus();
            }
            return status;
        }

        @Override
        public void onValueChanged(IFinished callback) {
            Object oldValue = this.cachedIndexValue;
            this.cachedIndexValue = this.indexOperand == null ? null : this.indexOperand.getValue();
            super.onValueChanged(oldValue != this.cachedIndexValue, callback);
        }

        private Object getIndexValue() {
            if (this.cachedIndexValue == AbstractLookupOperator.NotCached.value) {
                return this.indexOperand == null ? null : this.indexOperand.getValue();
            }
            if (this.cachedIndexValue == Uninitialized.value) {
                this.cachedIndexValue = this.indexOperand == null ? null : this.indexOperand.getValue();
            }
            return this.cachedIndexValue;
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder(super.toString());
            result.append('[');
            result.append(this.indexOperand.toString());
            result.append(']');
            return result.toString();
        }

        @Override
        public boolean isStale() {
            return this.indexOperand != null && this.indexOperand.isStale() || super.isStale(this.getIndexValue());
        }

        @Override
        public boolean isReadOnly() {
            return super.isReadOnly(this.getIndexValue());
        }
    }

    static class Factory
    implements IOperatorFactory<IBindValue, IUriValue> {
        Factory() {
        }

        @Override
        public IUriValue parse(String uri, boolean readOnly, AbstractUriBinding.Factory<IBindValue, IUriValue> factory, int precedence, AbstractBindProvider backplane) throws UriParseException {
            int pos = factory.findLastIndexOf(uri, "[");
            if (pos == 0) {
                StringBuilder msg = new StringBuilder();
                msg.append("I found a '[]' operator but nothing in front of it.");
                msg.append("  To be honest, I was expecting to find something before the '[' in the following text: ");
                msg.append(uri);
                throw new UriParseException(msg.toString());
            }
            if (pos > 0) {
                String arrayText = uri.substring(0, pos);
                String remainingText = uri.substring(pos + 1);
                if ((pos = factory.findMatchingBrace(remainingText, "[", "]")) < 0) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("I found a '[' operator, but I couldn't find the matching ']' operator.");
                    msg.append("  To be honest I was expecting one in the following text: ");
                    msg.append(remainingText);
                    throw new UriParseException(msg.toString());
                }
                if (pos == 0) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("I found an empty array operator '[]'.  To be honest, I was expecting to find something in them.");
                    throw new UriParseException(msg.toString());
                }
                String indexText = remainingText.substring(0, pos).trim();
                remainingText = remainingText.substring(pos + 1).trim();
                ArrayOperator result = new ArrayOperator((IUriValue)factory.parseExpression(arrayText.trim(), true, precedence, backplane));
                result.indexOperand = (IUriValue)factory.parseExpression(indexText, true, 0, backplane);
                if (remainingText.length() == 0) {
                    return result;
                }
                if (remainingText.startsWith(".")) {
                    if (remainingText.length() == 1) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("I found an array operator '[]' followed by a dot operator without anything following it.");
                        msg.append("  To be honest, I was expecting to find a field name after the dot operator in the following text: ");
                        msg.append(uri);
                        throw new UriParseException(msg.toString());
                    }
                    return DotOperator.factory.parse(uri.substring(0, arrayText.length() + pos + 2), result, remainingText.substring(1).trim(), factory, backplane);
                }
                StringBuilder msg = new StringBuilder();
                msg.append("I found an array operator '[]' with unexpected characters following it.");
                msg.append("  To be honest, I was expecting to find another operator after the ']' in the following text: ");
                msg.append(remainingText);
                throw new UriParseException(msg.toString());
            }
            return null;
        }

        @Override
        public String getOperator() {
            return "[";
        }
    }
}

