/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.internal.expressionParser.AbstractLiteralBinding;
import com.ti.backplane.internal.expressionParser.IUriValue;
import com.ti.backplane.internal.expressionParser.UriParseException;
import com.ti.backplane.internal.expressionParser.UriUtility;

class BooleanLiteral
extends AbstractLiteralBinding<Boolean, IBindValue>
implements IBindValue,
IUriValue {
    public BooleanLiteral(boolean literal) {
        this.literalValue = new Boolean(literal);
    }

    @Override
    public String toOperandText() {
        return (Boolean)this.literalValue != false ? "true" : "false";
    }

    @Override
    public String toString() {
        return this.toOperandText();
    }

    public static Boolean parse(String literal) {
        boolean clear;
        boolean set = literal.compareTo("true") == 0;
        boolean bl = clear = literal.compareTo("false") == 0;
        if (set || clear) {
            return new Boolean(set);
        }
        return null;
    }

    public static BooleanLiteral parseLiteral(String literal) throws UriParseException {
        Boolean result = BooleanLiteral.parse(literal = UriUtility.getPath(literal));
        if (result != null) {
            return new BooleanLiteral(result);
        }
        return null;
    }

    public BooleanLiteral parseLiteralOperand(String literal) throws UriParseException {
        return BooleanLiteral.parseLiteral(literal);
    }
}

