/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.AbstractBindProvider;
import com.ti.backplane.bind.IBindListener;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IChangedListener;
import com.ti.backplane.bind.IDisposable;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStaleListener;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.expressionParser.AbstractUriBinding;
import com.ti.backplane.internal.expressionParser.IBindingContext;
import com.ti.backplane.internal.expressionParser.IOperatorFactory;
import com.ti.backplane.internal.expressionParser.IUriValue;
import com.ti.backplane.internal.expressionParser.UriParseException;

class ConditionalOperator
implements IUriValue {
    static final String openingBrace = "?";
    static final String closingBrace = ":";
    protected IUriValue condition;
    protected IUriValue trueOperand;
    protected IUriValue falseOperand;
    static Factory factory = new Factory();

    ConditionalOperator() {
    }

    private Binding createBinding() {
        return new Binding();
    }

    @Override
    public IBindValue bind(IBindingContext context) {
        Binding result = this.createBinding();
        result.condition = (IBindValue)this.condition.bind(context);
        result.trueOperand = (IBindValue)this.trueOperand.bind(context);
        result.falseOperand = (IBindValue)this.falseOperand.bind(context);
        return result;
    }

    @Override
    public String toOperandText() {
        StringBuilder text = new StringBuilder();
        text.append(this.condition.toOperandText());
        text.append(" ? ");
        text.append(this.trueOperand.toOperandText());
        text.append(" : ");
        text.append(this.falseOperand.toOperandText());
        return text.toString();
    }

    public String toString() {
        return "value:" + this.toOperandText();
    }

    protected static class Binding
    implements IBindValue,
    IDisposable {
        IBindValue condition;
        IBindValue trueOperand;
        IBindValue falseOperand;
        String fName;

        protected Binding() {
        }

        @Override
        public void addChangedListener(IChangedListener listener) {
            this.condition.addChangedListener(listener);
            this.trueOperand.addChangedListener(listener);
            this.falseOperand.addChangedListener(listener);
        }

        @Override
        public void removeChangedListener(IChangedListener listener) {
            this.condition.removeChangedListener(listener);
            this.trueOperand.removeChangedListener(listener);
            this.falseOperand.removeChangedListener(listener);
        }

        @Override
        public void addBindListener(IBindListener listener) {
            this.condition.addBindListener(listener);
            this.trueOperand.addBindListener(listener);
            this.falseOperand.addBindListener(listener);
        }

        @Override
        public void removeBindListener(IBindListener listener) {
            this.condition.removeBindListener(listener);
            this.trueOperand.removeBindListener(listener);
            this.falseOperand.removeBindListener(listener);
        }

        @Override
        public void dispose() {
            if (this.condition instanceof IDisposable) {
                ((IDisposable)((Object)this.condition)).dispose();
            }
            if (this.trueOperand instanceof IDisposable) {
                ((IDisposable)((Object)this.trueOperand)).dispose();
            }
            if (this.falseOperand instanceof IDisposable) {
                ((IDisposable)((Object)this.falseOperand)).dispose();
            }
        }

        protected IBindValue getConditionalBranch() {
            Object value = this.condition.getValue();
            boolean test = false;
            if (value != null) {
                test = value instanceof Boolean ? (Boolean)value : (value instanceof Number ? ((Number)value).intValue() != 0 : value.toString().compareToIgnoreCase("true") == 0);
            }
            return test ? this.trueOperand : this.falseOperand;
        }

        @Override
        public Object getValue() {
            return this.getConditionalBranch().getValue();
        }

        @Override
        public void setValue(Object value, IFinished callback) {
            this.getConditionalBranch().setValue(value, callback);
        }

        @Override
        public Class<?> getType() {
            return this.getConditionalBranch().getType();
        }

        @Override
        public IStatus getStatus() {
            return this.getConditionalBranch().getStatus();
        }

        @Override
        public void setStatus(IStatus status) {
            this.getConditionalBranch().setStatus(status);
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.condition.toString());
            result.append(" ? ");
            result.append(this.trueOperand.toString());
            result.append(" : ");
            result.append(this.falseOperand.toString());
            return result.toString();
        }

        @Override
        public boolean isStale() {
            return this.condition.isStale() || this.getConditionalBranch().isStale();
        }

        @Override
        public void addStaleListener(IStaleListener listener) {
            this.condition.addStaleListener(listener);
            this.trueOperand.addStaleListener(listener);
            this.falseOperand.addStaleListener(listener);
        }

        @Override
        public void removeStaleListener(IStaleListener listener) {
            this.condition.removeStaleListener(listener);
            this.trueOperand.removeStaleListener(listener);
            this.falseOperand.removeStaleListener(listener);
        }

        @Override
        public boolean isReadOnly() {
            return this.getConditionalBranch().isReadOnly();
        }

        @Override
        public void setName(String name) {
            this.fName = name;
        }

        @Override
        public String getName() {
            return this.fName;
        }
    }

    static class Factory
    implements IOperatorFactory<IBindValue, IUriValue> {
        Factory() {
        }

        @Override
        public IUriValue parse(String uri, boolean readOnly, AbstractUriBinding.Factory<IBindValue, IUriValue> factory, int precedence, AbstractBindProvider backplane) throws UriParseException {
            int pos = factory.findFirstIndexOf(uri, ConditionalOperator.openingBrace, 0);
            if (pos == 0) {
                StringBuilder msg = new StringBuilder();
                msg.append("I found a '?' operator but nothing in front of it.");
                msg.append("  To be honest, I was expecting to find something before the '?' in the following text: ");
                msg.append(uri);
                throw new UriParseException(msg.toString());
            }
            if (pos > 0) {
                String conditionText = uri.substring(0, pos);
                String remainingText = uri.substring(pos + 1);
                if ((pos = factory.findMatchingBrace(remainingText, ConditionalOperator.openingBrace, ConditionalOperator.closingBrace)) < 0) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("I found a '?' operator, but I couldn't find the matching ':' operator.");
                    msg.append("  To be honest I was expecting one in the following text: ");
                    msg.append(remainingText);
                    throw new UriParseException(msg.toString());
                }
                if (pos == 0) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("I found a ':' imediately following a '?' operator.  To be honest, I was expecting to find something between them.");
                    throw new UriParseException(msg.toString());
                }
                if (pos >= remainingText.length() - 1) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("I found a '?' operator a with matching ':', but nothing after the ':' operator.  ");
                    msg.append("  To be honest, I was expecting to find something after the ':' in the following text: ");
                    msg.append(remainingText);
                    throw new UriParseException(msg.toString());
                }
                String trueText = remainingText.substring(0, pos);
                String falseText = remainingText.substring(pos + 1);
                ConditionalOperator result = new ConditionalOperator();
                result.condition = (IUriValue)factory.parseExpression(conditionText.trim(), true, precedence, backplane);
                result.trueOperand = (IUriValue)factory.parseExpression(trueText.trim(), readOnly, precedence, backplane);
                result.falseOperand = (IUriValue)factory.parseExpression(falseText.trim(), readOnly, precedence, backplane);
                return result;
            }
            return null;
        }

        @Override
        public String getOperator() {
            return ConditionalOperator.openingBrace;
        }
    }
}

