/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.AbstractBindProvider;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.expressionParser.AbstractLookupOperator;
import com.ti.backplane.internal.expressionParser.AbstractUriBinding;
import com.ti.backplane.internal.expressionParser.IBindingContext;
import com.ti.backplane.internal.expressionParser.IOperatorFactory;
import com.ti.backplane.internal.expressionParser.IUriValue;
import com.ti.backplane.internal.expressionParser.UriParseException;

public class DotOperator
extends AbstractLookupOperator {
    private static final String operator = ".";
    protected String rightOperand;
    static Factory factory = new Factory();

    public DotOperator(IUriValue leftOperand, String fieldNames) {
        super(leftOperand);
        this.rightOperand = fieldNames;
    }

    @Override
    protected Binding createBinding() {
        return new Binding();
    }

    @Override
    public IBindValue bind(IBindingContext context) {
        Binding result = (Binding)super.bind(context);
        result.rightOperand = this.rightOperand;
        return result;
    }

    @Override
    public String toOperandText() {
        StringBuilder text = new StringBuilder();
        text.append(super.toOperandText());
        text.append(operator);
        text.append(this.rightOperand);
        return text.toString();
    }

    protected static class Binding
    extends AbstractLookupOperator.Binding {
        private String rightOperand;

        public Binding(IBindValue lValue, String rValue) {
            super(lValue);
            this.rightOperand = rValue;
        }

        public Binding() {
        }

        @Override
        public Object getValue() {
            return super.getValue(this.rightOperand);
        }

        @Override
        protected IBindValue getLookupBinding(IStatus[] status) {
            return super.getLookupBinding(this.rightOperand, status);
        }

        @Override
        public void setValue(Object value, IFinished callback) {
            super.setValue(this.rightOperand, value, callback);
        }

        @Override
        public Class<?> getType() {
            Object value = super.getValue(this.rightOperand);
            return value == null ? String.class : value.getClass();
        }

        @Override
        public void onValueChanged(IFinished callback) {
            super.onValueChanged(false, callback);
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder(super.toString());
            result.append(DotOperator.operator);
            result.append(this.rightOperand);
            return result.toString();
        }

        @Override
        public boolean isStale() {
            return super.isStale(this.rightOperand);
        }

        @Override
        public boolean isReadOnly() {
            return super.isReadOnly(this.rightOperand);
        }
    }

    static class Factory
    implements IOperatorFactory<IBindValue, IUriValue> {
        Factory() {
        }

        @Override
        public IUriValue parse(String uri, boolean readOnly, AbstractUriBinding.Factory<IBindValue, IUriValue> factory, int precedence, AbstractBindProvider backplane) throws UriParseException {
            int pos = factory.findLastIndexOf(uri, DotOperator.operator);
            if (pos > 0 && pos < uri.length() - 1) {
                String operandText = uri.substring(0, pos);
                IUriValue leftOperand = (IUriValue)factory.parseExpression(operandText.trim(), readOnly, precedence, backplane);
                operandText = uri.substring(pos + DotOperator.operator.length());
                return new DotOperator(leftOperand, operandText.trim());
            }
            return null;
        }

        IUriValue parse(String leftUri, IUriValue leftOperand, String rightOperand, AbstractUriBinding.Factory<IBindValue, IUriValue> factory, AbstractBindProvider backplane) throws UriParseException {
            int pos = rightOperand.lastIndexOf(DotOperator.operator);
            if (pos > 0 && pos < rightOperand.length() - 1) {
                String operandText = rightOperand.substring(0, pos).trim();
                rightOperand = rightOperand.substring(pos + 1);
                leftOperand = this.parse(leftUri, leftOperand, operandText, factory, backplane);
                leftUri = String.valueOf(leftUri) + DotOperator.operator + operandText;
            } else if (pos >= 0) {
                StringBuilder msg = new StringBuilder();
                msg.append("Unexpected dot operator encountered \"");
                if (pos == 0) {
                    msg.append("at the beginning of \"");
                } else {
                    msg.append("at the end of \"");
                }
                msg.append(rightOperand);
                msg.append("\".  The dot operator is only supported within identifiers or immediately following an array operator; for example, \"A[B].x.y.z\".");
                throw new UriParseException(msg.toString());
            }
            leftOperand = factory.registerSubExpression(leftOperand, leftUri, backplane);
            return new DotOperator(leftOperand, rightOperand);
        }

        @Override
        public String getOperator() {
            return DotOperator.operator;
        }
    }
}

