/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.IBackplane;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IChangedListener;
import com.ti.backplane.internal.bind.FinishedCallback;
import com.ti.backplane.internal.bind.IFileLocationResolver;
import com.ti.backplane.internal.expressionParser.AbstractFunctionOperator;
import com.ti.backplane.internal.expressionParser.IBindingContext;
import com.ti.backplane.internal.expressionParser.IOperatorFactory;
import com.ti.backplane.internal.expressionParser.IUriValue;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class FileExistsOperator
extends AbstractFunctionOperator<IBindValue, IUriValue>
implements IUriValue {
    private static final String FN = "exists";
    static IOperatorFactory<IBindValue, IUriValue> factory = new Factory();

    public FileExistsOperator() {
    }

    public FileExistsOperator(IUriValue operand) {
        this.functionName = FN;
        this.operands = new ArrayList(1);
        this.operands.add(operand);
    }

    @Override
    protected AbstractFunctionOperator.Binding<IBindValue> createBinding(IBindingContext context) {
        return new Binding(context.getFileLocator(), context.getBackplane());
    }

    private static class Binding
    extends AbstractFunctionOperator.Binding<IBindValue> {
        private static long POLLING_FILE_EXISTS_TIMEOUT_MS = 1500L;
        private PollingFileExistsJob pollingJob = null;
        private boolean exists = false;
        private IFileLocationResolver fileLocator;
        private IBackplane backplane;
        private Object cachedOperandValue = null;
        private ArrayList<IChangedListener> changedListeners = new ArrayList(5);

        public Binding(IFileLocationResolver fileLocator, IBackplane backplane) {
            this.fileLocator = fileLocator;
            this.backplane = backplane;
        }

        private boolean doesFileExist(String filename) {
            boolean result = false;
            if (filename != null && this.fileLocator != null) {
                File file = new File(filename);
                if (!file.isAbsolute()) {
                    file = (filename = this.fileLocator.resolveAppPath(filename)) != null ? new File(filename) : null;
                }
                result = file != null && file.exists();
            }
            return result;
        }

        @Override
        public Object getValue() {
            this.cachedOperandValue = ((IBindValue)this.operands.get(0)).getValue();
            if (this.cachedOperandValue != null) {
                this.exists = this.doesFileExist(this.cachedOperandValue.toString());
            }
            return this.exists;
        }

        @Override
        protected String getFunctionName() {
            return FileExistsOperator.FN;
        }

        @Override
        public Class<?> getType() {
            return Boolean.class;
        }

        @Override
        public void addChangedListener(IChangedListener listener) {
            if (this.changedListeners.size() == 0) {
                if (this.pollingJob == null) {
                    this.pollingJob = new PollingFileExistsJob();
                }
                this.pollingJob.start();
            }
            this.changedListeners.add(listener);
            super.addChangedListener(listener);
        }

        @Override
        public void removeChangedListener(IChangedListener listener) {
            if (this.changedListeners.size() > 0) {
                this.changedListeners.remove(listener);
                super.removeChangedListener(listener);
                if (this.changedListeners.size() == 0) {
                    this.pollingJob.stop();
                }
            }
        }

        private void notifyChangedListeners() {
            FinishedCallback finished = new FinishedCallback();
            for (IChangedListener listener : this.changedListeners) {
                listener.onValueChanged(finished);
            }
        }

        private class PollingFileExistsJob
        extends Job {
            private boolean enabled;

            public PollingFileExistsJob() {
                super("checking file(s) exists");
                this.enabled = false;
                this.setPriority(20);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (this.enabled) {
                    Binding.this.backplane.getRealm().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (Binding.this.cachedOperandValue != null && Binding.this.exists != Binding.this.doesFileExist(Binding.this.cachedOperandValue.toString())) {
                                    Binding.this.notifyChangedListeners();
                                }
                            }
                            finally {
                                PollingFileExistsJob.this.schedule(POLLING_FILE_EXISTS_TIMEOUT_MS);
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }

            void start() {
                this.enabled = true;
                this.schedule(POLLING_FILE_EXISTS_TIMEOUT_MS);
            }

            void stop() {
                this.cancel();
                this.enabled = false;
            }
        }
    }

    private static class Factory
    extends AbstractFunctionOperator.Factory<IBindValue, IUriValue> {
        Factory() {
            super(FileExistsOperator.FN, 1);
        }

        @Override
        protected AbstractFunctionOperator<IBindValue, IUriValue> createOperator() {
            return new FileExistsOperator();
        }
    }
}

