/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.internal.expressionParser.AbstractLiteralBinding;
import com.ti.backplane.internal.expressionParser.IUriValue;
import com.ti.backplane.internal.expressionParser.UriParseException;
import com.ti.backplane.internal.expressionParser.UriUtility;
import java.text.NumberFormat;
import java.text.ParseException;

public class NumberLiteral
extends AbstractLiteralBinding<Number, IBindValue>
implements IBindValue,
IUriValue {
    public NumberLiteral(Number literal) {
        this.literalValue = literal;
    }

    @Override
    public String toOperandText() {
        return ((Number)this.literalValue).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Number parse(String uri, NumberFormat formatter) {
        try {
            String literal = UriUtility.getPath(uri);
            if (literal.length() <= 1) return formatter.parse(literal);
            try {
                char digit;
                if (literal.startsWith("0") && Character.isLetter(digit = literal.charAt(1))) {
                    digit = Character.toLowerCase(digit);
                    int radix = 10;
                    switch (digit) {
                        case 'x': {
                            radix = 16;
                            break;
                        }
                        case 'b': {
                            radix = 2;
                            break;
                        }
                        case 'o': {
                            radix = 8;
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    if (literal.length() <= 2) return Integer.parseInt(literal.substring(2), radix);
                    digit = literal.charAt(literal.length() - 1);
                    if (!Character.isLetter(digit = Character.toLowerCase(digit))) return Integer.parseInt(literal.substring(2), radix);
                    switch (digit) {
                        case 'l': {
                            return Long.parseLong(literal.substring(2, literal.length() - 1), radix);
                        }
                        case 'h': {
                            return Short.parseShort(literal.substring(2, literal.length() - 1), radix);
                        }
                    }
                    return null;
                }
                char lastLetter = literal.charAt(literal.length() - 1);
                if (!Character.isLetter(lastLetter)) return formatter.parse(literal);
                lastLetter = Character.toLowerCase(lastLetter);
                if ((literal = literal.substring(0, literal.length() - 1)).indexOf(46) > 0) {
                    switch (lastLetter) {
                        case 'l': {
                            return Double.parseDouble(literal);
                        }
                        case 'h': {
                            return Float.valueOf(Float.parseFloat(literal));
                        }
                    }
                    return null;
                }
                switch (lastLetter) {
                    case 'l': {
                        return Long.parseLong(literal);
                    }
                    case 'h': {
                        return Short.parseShort(literal);
                    }
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static NumberLiteral parseLiteral(String uri) throws UriParseException {
        Number result = NumberLiteral.parse(uri, NumberFormat.getInstance());
        return result == null ? null : new NumberLiteral(result);
    }

    public static NumberLiteral parseLiteralOperand(String uri) throws UriParseException {
        return NumberLiteral.parseLiteral(uri);
    }
}

