/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.AbstractBindProvider;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.internal.expressionParser.AbstractUriBinding;
import com.ti.backplane.internal.expressionParser.IOperatorFactory;
import com.ti.backplane.internal.expressionParser.IUriElement;
import com.ti.backplane.internal.expressionParser.UriParseException;
import java.util.ArrayList;

class OperatorList<T extends IBind, V extends IUriElement<T>>
implements IOperatorFactory<T, V> {
    ArrayList<IOperatorFactory<T, V>> samePrecedenceOperators;

    OperatorList(IOperatorFactory<T, V> op1, IOperatorFactory<T, V> op2) {
        this.samePrecedenceOperators = new ArrayList(2);
        this.samePrecedenceOperators.add(op1);
        this.samePrecedenceOperators.add(op2);
    }

    OperatorList(IOperatorFactory<T, V> op1, IOperatorFactory<T, V> op2, IOperatorFactory<T, V> op3) {
        this.samePrecedenceOperators = new ArrayList(3);
        this.samePrecedenceOperators.add(op1);
        this.samePrecedenceOperators.add(op2);
        this.samePrecedenceOperators.add(op3);
    }

    OperatorList(IOperatorFactory<T, V> op1, IOperatorFactory<T, V> op2, IOperatorFactory<T, V> op3, IOperatorFactory<T, V> op4) {
        this.samePrecedenceOperators = new ArrayList(4);
        this.samePrecedenceOperators.add(op1);
        this.samePrecedenceOperators.add(op2);
        this.samePrecedenceOperators.add(op3);
        this.samePrecedenceOperators.add(op4);
    }

    @Override
    public V parse(String uri, boolean readOnly, AbstractUriBinding.Factory<T, V> factory, int precedence, AbstractBindProvider backplane) throws UriParseException {
        int firstOperator = -1;
        IOperatorFactory<T, V> operator = null;
        for (IOperatorFactory<T, V> parser : this.samePrecedenceOperators) {
            int pos = factory.findLastIndexOf(uri, parser.getOperator());
            if (pos <= firstOperator) continue;
            firstOperator = pos;
            operator = parser;
        }
        if (operator != null) {
            return operator.parse(uri, readOnly, factory, precedence, backplane);
        }
        return null;
    }

    @Override
    public String getOperator() {
        return this.samePrecedenceOperators.get(0).getOperator();
    }
}

