/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.internal.bind.ErrorStatus;
import com.ti.backplane.internal.expressionParser.AbstractFunctionOperator;
import com.ti.backplane.internal.expressionParser.IBindingContext;
import com.ti.backplane.internal.expressionParser.IOperatorFactory;
import com.ti.backplane.internal.expressionParser.IUriValue;

public class QOperator
extends AbstractFunctionOperator<IBindValue, IUriValue>
implements IUriValue {
    private static final String FN = "Q";
    static IOperatorFactory<IBindValue, IUriValue> factory = new Factory();

    @Override
    protected AbstractFunctionOperator.Binding<IBindValue> createBinding(IBindingContext context) {
        return new Binding();
    }

    private static class Binding
    extends AbstractFunctionOperator.Binding<IBindValue> {
        @Override
        public Object getValue() {
            Object value = ((IBindValue)this.operands.get(0)).getValue();
            Object q = ((IBindValue)this.operands.get(1)).getValue();
            if (value instanceof Number && q instanceof Number) {
                this.setStatus(null);
                return Math.scalb(((Number)value).doubleValue(), -((Number)q).intValue());
            }
            if (this.getStatus() == null) {
                this.setStatus(new ErrorStatus("Operator '" + this.getOperator() + "' only supports numeric parameters."));
            }
            return null;
        }

        @Override
        public void setValue(Object value, IFinished callback) {
            Object q = ((IBindValue)this.operands.get(1)).getValue();
            if (value instanceof String) {
                value = Double.parseDouble((String)value);
            }
            if (value instanceof Number && q instanceof Number) {
                long newValue = (long)(Math.scalb(((Number)value).doubleValue(), ((Number)q).intValue()) + 0.5);
                ((IBindValue)this.operands.get(0)).setValue(new Long(newValue), callback);
            } else {
                callback.done(new ErrorStatus("Operator '" + this.getOperator() + "' only supports numeric parameters."));
            }
        }

        @Override
        protected String getFunctionName() {
            return QOperator.FN;
        }

        @Override
        public Class<?> getType() {
            return Double.class;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }

    private static class Factory
    extends AbstractFunctionOperator.Factory<IBindValue, IUriValue> {
        Factory() {
            super(QOperator.FN, 2);
        }

        @Override
        protected AbstractFunctionOperator<IBindValue, IUriValue> createOperator() {
            return new QOperator();
        }
    }
}

