/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.internal.expressionParser.AbstractLiteralBinding;
import com.ti.backplane.internal.expressionParser.AbstractUriBinding;
import com.ti.backplane.internal.expressionParser.IUriValue;
import com.ti.backplane.internal.expressionParser.UriParseException;
import com.ti.backplane.internal.expressionParser.UriUtility;

class StringLiteral
extends AbstractLiteralBinding<String, IBindValue>
implements IBindValue,
IUriValue {
    public static final String singleQuote = "'";

    public StringLiteral(String literal) {
        this.literalValue = literal.replace("\\'", singleQuote);
        this.literalValue = ((String)this.literalValue).replace("\\\\", "\\");
    }

    @Override
    public String toOperandText() {
        String result = UriUtility.getPath((String)this.literalValue);
        result.replace(singleQuote, "\\'");
        result.replace("\\", "\\\\");
        return singleQuote + result + singleQuote;
    }

    @Override
    public String toString() {
        return (String)this.literalValue;
    }

    public static StringLiteral parseLiteral(String uri) throws UriParseException {
        return new StringLiteral(uri);
    }

    public static StringLiteral parseLiteralOperand(String uri) throws UriParseException {
        if (uri.startsWith(singleQuote)) {
            boolean escaped;
            int endPos = 0;
            do {
                endPos = uri.indexOf(singleQuote, endPos + 1);
                escaped = false;
                int i = endPos;
                while (i > 0 && uri.charAt(i - 1) == '\\') {
                    escaped = !escaped;
                    --i;
                }
            } while (escaped);
            if (endPos <= 0) {
                AbstractUriBinding.Factory.composeMissingClosingBraceErrMsg(uri, "single quote");
            } else if (endPos != uri.length() - 1) {
                AbstractUriBinding.Factory.composeMissingOperatorErrMsg(uri.substring(endPos + 1));
            } else {
                uri = uri.substring(1, uri.length() - 1);
                return StringLiteral.parseLiteral(uri);
            }
        }
        return null;
    }
}

