/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.AbstractBindProvider;
import com.ti.backplane.bind.IBindListener;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.bind.IChangedListener;
import com.ti.backplane.bind.IDisposable;
import com.ti.backplane.bind.IFinished;
import com.ti.backplane.bind.IStaleListener;
import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.ErrorStatus;
import com.ti.backplane.internal.expressionParser.AbstractUriBinding;
import com.ti.backplane.internal.expressionParser.IBindingContext;
import com.ti.backplane.internal.expressionParser.IOperatorFactory;
import com.ti.backplane.internal.expressionParser.IUriElement;
import com.ti.backplane.internal.expressionParser.IUriValue;
import com.ti.backplane.internal.expressionParser.UriParseException;

abstract class UnaryOperator<T extends IBindValue, V extends IUriElement<T>>
implements IUriValue {
    protected V operand;
    protected String operator;

    UnaryOperator() {
    }

    protected abstract Binding<T> createBinding();

    @Override
    public T bind(IBindingContext context) {
        Binding<T> result = this.createBinding();
        result.operand = (IBindValue)this.operand.bind(context);
        return (T)result;
    }

    @Override
    public String toOperandText() {
        return String.valueOf(this.operator) + this.operand.toOperandText();
    }

    public String toString() {
        return "value:" + this.toOperandText();
    }

    static abstract class Binding<T extends IBindValue>
    implements IBindValue,
    IDisposable {
        T operand;
        String fName;

        Binding() {
        }

        protected abstract String getOperator();

        @Override
        public void addChangedListener(IChangedListener listener) {
            this.operand.addChangedListener(listener);
        }

        @Override
        public void removeChangedListener(IChangedListener listener) {
            this.operand.removeChangedListener(listener);
        }

        @Override
        public IStatus getStatus() {
            return this.operand.getStatus();
        }

        @Override
        public void setStatus(IStatus status) {
            this.operand.setStatus(status);
        }

        @Override
        public void addBindListener(IBindListener listener) {
            this.operand.addBindListener(listener);
        }

        @Override
        public void removeBindListener(IBindListener listener) {
            this.operand.removeBindListener(listener);
        }

        @Override
        public void dispose() {
            if (this.operand instanceof IDisposable) {
                ((IDisposable)this.operand).dispose();
            }
        }

        @Override
        public void setValue(Object value, IFinished callback) {
            if (value == null) {
                return;
            }
            Object result = this.doBooleanOperation(value, true);
            if (result == null) {
                result = this.doNumericOperation(value, true);
            }
            if (result == null) {
                result = this.doArrayOperation(value, true);
            }
            if (result == null) {
                result = this.doStringOperation(value, true);
            }
            this.operand.setValue(result, callback);
        }

        @Override
        public Object getValue() {
            Object value = this.operand.getValue();
            if (value == null) {
                return null;
            }
            Object result = this.doBooleanOperation(value, false);
            if (result == null) {
                result = this.doNumericOperation(value, false);
            }
            if (result == null) {
                result = this.doArrayOperation(value, false);
            }
            if (result == null) {
                result = this.doStringOperation(value, false);
            }
            if (result instanceof IStatus) {
                this.setStatus((IStatus)result);
                result = null;
            }
            return result;
        }

        public Object doBooleanOperation(Object value, boolean write) {
            if (value instanceof Boolean) {
                if (this instanceof IBooleanOperator) {
                    return new Boolean(((IBooleanOperator)((Object)this)).getValue((Boolean)value, write));
                }
                return new ErrorStatus("Operator '" + this.getOperator() + "' does not support boolean types");
            }
            return null;
        }

        public Object doNumericOperation(Object value, boolean write) {
            if (value instanceof Number) {
                if (value instanceof Double) {
                    if (this instanceof IDecimalOperator) {
                        return new Double(((IDecimalOperator)((Object)this)).getValue(((Number)value).doubleValue(), write));
                    }
                    return new ErrorStatus("Operator '" + this.getOperator() + "' does not support floating point types");
                }
                if (value instanceof Float) {
                    if (this instanceof IDecimalOperator) {
                        return new Float(((IDecimalOperator)((Object)this)).getValue(((Number)value).doubleValue(), write));
                    }
                    return new ErrorStatus("Operator '" + this.getOperator() + "' does not support floating point types");
                }
                if (value instanceof Long) {
                    if (this instanceof IIntegerOperator) {
                        return new Long(((IIntegerOperator)((Object)this)).getValue(((Number)value).longValue(), write));
                    }
                    return new ErrorStatus("Operator '" + this.getOperator() + "' does not support integer types");
                }
                if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
                    if (this instanceof IIntegerOperator) {
                        return new Integer((int)((IIntegerOperator)((Object)this)).getValue(((Number)value).longValue(), write));
                    }
                    return new ErrorStatus("Operator '" + this.getOperator() + "' does not support integer types");
                }
                return new ErrorStatus("Operator '" + this.getOperator() + "' does not support numeric types");
            }
            return null;
        }

        private Object doArrayOperation(Object valueArray, boolean write) {
            if (valueArray instanceof Object[]) {
                if (this instanceof IArrayOperator) {
                    return ((IArrayOperator)((Object)this)).getValue((Object[])valueArray, write);
                }
                return new ErrorStatus("Operator '" + this.getOperator() + "' does not support array types");
            }
            return null;
        }

        private Object doStringOperation(Object value, boolean write) {
            if (this instanceof IStringOperator) {
                return ((IStringOperator)((Object)this)).getValue(value.toString(), write);
            }
            return new ErrorStatus("Operator '" + this.getOperator() + "' does not support string types");
        }

        @Override
        public Class<?> getType() {
            return this.operand.getType();
        }

        public String toString() {
            return String.valueOf(this.getOperator()) + this.operand.toString();
        }

        @Override
        public boolean isStale() {
            return this.operand.isStale();
        }

        @Override
        public void addStaleListener(IStaleListener listener) {
            this.operand.addStaleListener(listener);
        }

        @Override
        public void removeStaleListener(IStaleListener listener) {
            this.operand.removeStaleListener(listener);
        }

        @Override
        public boolean isReadOnly() {
            return this.operand.isReadOnly();
        }

        @Override
        public void setName(String name) {
            this.fName = name;
        }

        @Override
        public String getName() {
            return this.fName;
        }
    }

    static abstract class Factory<T extends IBindValue, V extends IUriElement<T>>
    implements IOperatorFactory<T, V> {
        private String operator;

        protected Factory(String operator) {
            this.operator = operator;
        }

        protected abstract UnaryOperator<T, V> createOperator();

        @Override
        public V parse(String uri, boolean readOnly, AbstractUriBinding.Factory<T, V> factory, int precedence, AbstractBindProvider backplane) throws UriParseException {
            String operandText;
            Object operand;
            if (uri.startsWith(this.operator) && (operand = factory.parseExpression((operandText = uri.substring(this.operator.length())).trim(), readOnly, precedence, backplane)) != null) {
                UnaryOperator<T, V> result = this.createOperator();
                result.operator = this.operator;
                result.operand = operand;
                return (V)result;
            }
            return null;
        }

        @Override
        public String getOperator() {
            return this.operator;
        }
    }

    protected static interface IArrayOperator {
        public Object[] getValue(Object[] var1, boolean var2);
    }

    protected static interface IBooleanOperator {
        public boolean getValue(boolean var1, boolean var2);
    }

    protected static interface IDecimalOperator {
        public double getValue(double var1, boolean var3);
    }

    protected static interface IIntegerOperator {
        public long getValue(long var1, boolean var3);
    }

    protected static interface IStringOperator {
        public String getValue(String var1, boolean var2);
    }
}

