/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

class UriUtility {
    public static final String LITERAL = "literal:";
    public static final String VALUE = "value:";
    public static final String REF = "ref:";
    public static final String FILE = "file:";
    public static final String HTTP = "http:";
    public static final String EMAIL = "email:";
    public static final String ACTION = "action:";
    public static final String HELP = "help:";

    UriUtility() {
    }

    public static boolean isURI(String guid) {
        return guid.indexOf(":") >= 0;
    }

    public static boolean isLiteral(String guid) {
        return !UriUtility.isURI(guid) || guid.startsWith(LITERAL);
    }

    public static boolean isValue(String guid) {
        return guid.startsWith(VALUE);
    }

    public static boolean isReference(String guid) {
        return guid.startsWith(REF);
    }

    public static boolean isFile(String guid) {
        return guid.startsWith(FILE);
    }

    public static boolean isHtml(String guid) {
        return guid.startsWith(HTTP);
    }

    public static boolean isAction(String guid) {
        return guid.startsWith(ACTION);
    }

    public static String getPath(String guid) {
        if (guid.startsWith(VALUE)) {
            return guid.substring(6);
        }
        int colonPos = guid.indexOf(58);
        if (colonPos >= 0) {
            return guid.substring(colonPos + 1);
        }
        return guid;
    }

    public static boolean isValidLiteral(String guid, String regex) {
        if (UriUtility.isLiteral(guid)) {
            String path = UriUtility.getPath(guid);
            return path.matches(regex);
        }
        return false;
    }

    public static String getProtocol(String guid) {
        int pos = guid == null ? -1 : guid.indexOf(58);
        return pos < 0 ? "" : guid.substring(0, pos + 1);
    }
}

