/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.expressionParser;

import com.ti.backplane.bind.AbstractBindProvider;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindValue;
import com.ti.backplane.internal.bind.DefaultBackplane;
import com.ti.backplane.internal.expressionParser.AbstractLiteralBinding;
import com.ti.backplane.internal.expressionParser.AbstractUriBinding;
import com.ti.backplane.internal.expressionParser.AdditionOperator;
import com.ti.backplane.internal.expressionParser.ArithmeticNotOperator;
import com.ti.backplane.internal.expressionParser.ArrayLiteral;
import com.ti.backplane.internal.expressionParser.ArrayOperator;
import com.ti.backplane.internal.expressionParser.BooleanLiteral;
import com.ti.backplane.internal.expressionParser.ConditionalOperator;
import com.ti.backplane.internal.expressionParser.DivisionOperator;
import com.ti.backplane.internal.expressionParser.EqualsOperator;
import com.ti.backplane.internal.expressionParser.FileExistsOperator;
import com.ti.backplane.internal.expressionParser.GreaterThanOperator;
import com.ti.backplane.internal.expressionParser.GreaterThanOrEqualsOperator;
import com.ti.backplane.internal.expressionParser.IBindingContext;
import com.ti.backplane.internal.expressionParser.IUriBindingFactory;
import com.ti.backplane.internal.expressionParser.IUriValue;
import com.ti.backplane.internal.expressionParser.LessThanOperator;
import com.ti.backplane.internal.expressionParser.LessThanOrEqualsOperator;
import com.ti.backplane.internal.expressionParser.LogicalAndOperator;
import com.ti.backplane.internal.expressionParser.LogicalNotOperator;
import com.ti.backplane.internal.expressionParser.LogicalOrOperator;
import com.ti.backplane.internal.expressionParser.MultiplicationOperator;
import com.ti.backplane.internal.expressionParser.NegationOperator;
import com.ti.backplane.internal.expressionParser.NotEqualsOperator;
import com.ti.backplane.internal.expressionParser.NumberLiteral;
import com.ti.backplane.internal.expressionParser.OperatorList;
import com.ti.backplane.internal.expressionParser.QOperator;
import com.ti.backplane.internal.expressionParser.RemainderOperator;
import com.ti.backplane.internal.expressionParser.StringLiteral;
import com.ti.backplane.internal.expressionParser.SubtractionOperator;
import com.ti.backplane.internal.expressionParser.UriParseException;

public class UriValueBinding
extends AbstractUriBinding<IBindValue>
implements IUriValue {
    static IUriBindingFactory<IUriValue> factory = new Factory();

    UriValueBinding(String identifier) {
        super(identifier);
    }

    @Override
    public IBindValue bind(IBindingContext context) {
        IBind result = context.getBindingProvider().getBinding(this.identifier);
        if (result instanceof IBindValue) {
            return (IBindValue)result;
        }
        return null;
    }

    static String composeInvalidSubExpressionErrMsg(String uri) throws UriParseException {
        StringBuilder msg = new StringBuilder();
        msg.append("The sub expression \"");
        msg.append(uri);
        msg.append("\" does not evaluate to a value binding.  To be honest, this looks like a programmers error.  Sorry.\"");
        throw new UriParseException(msg.toString());
    }

    protected static class Factory
    extends AbstractUriBinding.Factory<IBindValue, IUriValue> {
        protected Factory() {
            this.addBraces("[", "]");
            this.addBraces("'", "'");
            this.addOperatorFactory(ConditionalOperator.factory);
            this.addOperatorFactory(LogicalOrOperator.factory);
            this.addOperatorFactory(LogicalAndOperator.factory);
            this.addOperatorFactory(new OperatorList<IBindValue, IUriValue>(EqualsOperator.factory, NotEqualsOperator.factory));
            this.addOperatorFactory(new OperatorList<IBindValue, IUriValue>(GreaterThanOrEqualsOperator.factory, LessThanOrEqualsOperator.factory, GreaterThanOperator.factory, LessThanOperator.factory));
            this.addOperatorFactory(new OperatorList<IBindValue, IUriValue>(AdditionOperator.factory, SubtractionOperator.factory));
            this.addOperatorFactory(new OperatorList<IBindValue, IUriValue>(MultiplicationOperator.factory, DivisionOperator.factory, RemainderOperator.factory));
            this.addOperatorFactory(new OperatorList<IBindValue, IUriValue>(NegationOperator.factory, ArithmeticNotOperator.factory, LogicalNotOperator.factory));
            this.addOperatorFactory(ArrayOperator.factory);
            this.addOperatorFactory(FileExistsOperator.factory);
            this.addOperatorFactory(QOperator.factory);
        }

        @Override
        protected IUriValue bindValue(String identifier) {
            return new UriValueBinding(identifier);
        }

        @Override
        protected IUriValue parseLiteralOperand(String operand) throws UriParseException {
            AbstractLiteralBinding result = ArrayLiteral.parseLiteralOperand(operand);
            if (result == null) {
                result = NumberLiteral.parseLiteralOperand(operand);
            }
            if (result == null) {
                result = BooleanLiteral.parseLiteral(operand);
            }
            if (result == null) {
                result = StringLiteral.parseLiteralOperand(operand);
            }
            if (result == null) {
                throw new UriParseException("To be honest, I was expecting \"" + operand + "\" to be a number, true, false, or to be enclosed in single quotes like '<string>' or array delimiters like \"{a;b;c}\".");
            }
            return result;
        }

        @Override
        protected IUriValue parseLiteral(String uri) throws UriParseException {
            AbstractLiteralBinding result = ArrayLiteral.parseLiteral(uri);
            if (result == null) {
                result = NumberLiteral.parseLiteral(uri);
            }
            if (result == null) {
                result = BooleanLiteral.parseLiteral(uri);
            }
            if (result == null) {
                result = StringLiteral.parseLiteral(uri);
            }
            return result;
        }

        @Override
        public IUriValue parseExpression(String uri, boolean readOnly, int precedence, AbstractBindProvider backplane) throws UriParseException {
            IBind binding;
            if (uri == null || uri.length() == 0) {
                throw new UriParseException("Empty param");
            }
            if (backplane != null && (binding = backplane.findBinding(uri)) != null) {
                if (binding instanceof IBindValue) {
                    return new UriSubExpressionAdapter(uri, new UriSubExpressionBinding((IBindValue)binding));
                }
                throw new UriParseException(UriValueBinding.composeInvalidSubExpressionErrMsg(uri));
            }
            IUriValue result = (IUriValue)super.parseExpression(uri, readOnly, precedence, backplane);
            if (result != null && backplane != null) {
                result = new UriSubExpressionAdapter(uri, result);
            }
            return result;
        }

        @Override
        public IUriValue registerSubExpression(IUriValue operand, String uri, AbstractBindProvider backplane) throws UriParseException {
            if (backplane != null) {
                IBind binding = backplane.findBinding(uri);
                if (binding != null) {
                    if (binding instanceof IBindValue) {
                        return new UriSubExpressionAdapter(uri, new UriSubExpressionBinding((IBindValue)binding));
                    }
                    throw new UriParseException(UriValueBinding.composeInvalidSubExpressionErrMsg(uri));
                }
                return new UriSubExpressionAdapter(uri, operand);
            }
            return operand;
        }
    }

    private static class UriSubExpressionAdapter
    implements IUriValue {
        private IUriValue subExpressionValue;
        private String subExpression;

        public UriSubExpressionAdapter(String uri, IUriValue value) {
            this.subExpressionValue = value;
            this.subExpression = uri;
        }

        @Override
        public IBindValue bind(IBindingContext context) {
            String key;
            DefaultBackplane backplane = context.getBackplane();
            IBind result = backplane.findBinding(key = UriSubExpressionAdapter.removeSpaces(this.subExpression));
            if (result == null) {
                IBindValue newBinding = (IBindValue)this.subExpressionValue.bind(context);
                if (newBinding != null) {
                    backplane.putBinding(key, newBinding);
                    return newBinding;
                }
            } else if (result instanceof IBindValue) {
                return (IBindValue)result;
            }
            return null;
        }

        @Override
        public String toOperandText() {
            String result = this.subExpressionValue.toOperandText();
            return result == null ? this.subExpression : result;
        }

        public String toString() {
            String result = this.subExpressionValue.toString();
            return result == null ? this.subExpression : result;
        }

        /*
         * Unable to fully structure code
         */
        private static String removeSpaces(String uri) {
            block6: {
                result = null;
                pos = uri.indexOf(32);
                prevPos = 0;
                if (pos <= 0) break block6;
                quote = uri.indexOf(39);
                ** GOTO lbl22
                {
                    quote = uri.indexOf(39, quote + 1);
                    while (quote > pos && pos > 0) {
                        pos = uri.indexOf(32, pos + 1);
                    }
                    if (quote > 0) {
                        quote = uri.indexOf(39, quote + 1);
                    }
                    do {
                        if (quote < pos && quote >= 0) continue block0;
                        if (pos <= 0) continue;
                        if (result == null) {
                            result = new StringBuilder();
                        }
                        result.append(uri.substring(prevPos, pos));
                        prevPos = pos + 1;
                        pos = uri.indexOf(32, prevPos);
lbl22:
                        // 3 sources

                    } while (pos > 0);
                }
                if (prevPos > 0) {
                    result.append(uri.substring(prevPos));
                }
            }
            return result == null ? uri : result.toString();
        }
    }

    private static class UriSubExpressionBinding
    implements IUriValue {
        private IBindValue subExpressionBinding;

        public UriSubExpressionBinding(IBindValue existingBinding) {
            this.subExpressionBinding = existingBinding;
        }

        @Override
        public IBindValue bind(IBindingContext context) {
            return this.subExpressionBinding;
        }

        @Override
        public String toOperandText() {
            return null;
        }

        public String toString() {
            return null;
        }
    }
}

