/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.update;

import com.ti.backplane.internal.BackplanePlugin;
import com.ti.backplane.internal.IDebugFilter;
import com.ti.backplane.internal.update.IUpdateCompletedCallback;
import com.ti.backplane.internal.update.IUpdateListener;
import com.ti.backplane.internal.update.UpdateCompletedCounter;
import com.ti.backplane.internal.update.UpdateManager;
import java.util.ArrayList;

public class ContinuousUpdator {
    private ArrayList<IUpdateListener> allListeners = new ArrayList();
    private ArrayList<IUpdateListener> enabledListeners = new ArrayList();
    private UpdateManager manager;
    private Thread thread;
    private boolean threadExitRequested;
    private boolean enabled;
    private boolean waitForUpdateToComplete;
    private long lastUpdateStartTime;
    long startUpdateTime = 0L;
    long totalUpdateTime = 0L;
    long lastTraceTime = 0L;
    long updateCount = 0L;
    long updatePerTrace = 100L;

    ContinuousUpdator(UpdateManager updateManager) {
        this.manager = updateManager;
    }

    public void addUpdateListener(IUpdateListener listener, boolean enabled) {
        if (this.allListeners.contains(listener)) {
            return;
        }
        this.allListeners.add(listener);
        if (enabled) {
            this.enabledListeners.add(listener);
            this.startThread();
        }
    }

    public void removeUpdateListener(IUpdateListener listener) {
        this.allListeners.remove(listener);
        this.enabledListeners.remove(listener);
        this.stopThread();
    }

    private void startThread() {
        if (this.thread != null) {
            return;
        }
        if (!this.enabled) {
            return;
        }
        if (this.enabledListeners.size() == 0) {
            return;
        }
        this.threadExitRequested = false;
        this.waitForUpdateToComplete = false;
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        if (BackplanePlugin.DEBUG) {
                            BackplanePlugin.debug("refresh thread started", IDebugFilter.UPDATE);
                        }
                        while (ContinuousUpdator.this.continueLooping()) {
                            try {
                                Thread.sleep(ContinuousUpdator.this.manager.getRefreshInterval());
                            }
                            catch (InterruptedException interruptedException) {}
                            ContinuousUpdator.this.oneIteration();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (BackplanePlugin.DEBUG) {
                            BackplanePlugin.debug("refresh thread ended", IDebugFilter.UPDATE);
                        }
                    }
                }
                finally {
                    if (BackplanePlugin.DEBUG) {
                        BackplanePlugin.debug("refresh thread ended", IDebugFilter.UPDATE);
                    }
                }
            }
        }, "Continuous Updator");
        this.thread.start();
    }

    private void oneIteration() {
        if (!this.enabled) {
            return;
        }
        if (this.enabledListeners.size() == 0) {
            return;
        }
        if (this.waitForUpdateToComplete) {
            long updateTime;
            if (BackplanePlugin.DEBUG && (updateTime = System.currentTimeMillis() - this.lastUpdateStartTime) > 3000L) {
                BackplanePlugin.debug("transaction timeout = " + updateTime, IDebugFilter.TRANSACTIONS);
                this.lastUpdateStartTime = System.currentTimeMillis();
            }
            return;
        }
        this.triggerUpdate();
    }

    private boolean continueLooping() {
        return !this.threadExitRequested;
    }

    void stopThread() {
        if (this.thread == null) {
            return;
        }
        if (this.enabled && this.enabledListeners.size() > 0) {
            return;
        }
        this.threadExitRequested = true;
        this.thread = null;
    }

    public void enable(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.startThread();
        } else {
            this.stopThread();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void triggerUpdate() {
        int listenerCount = this.enabledListeners.size();
        if (listenerCount == 0) {
            return;
        }
        this.waitForUpdateToComplete = true;
        this.lastUpdateStartTime = System.currentTimeMillis();
        if (BackplanePlugin.DEBUG) {
            BackplanePlugin.debug("refresh start, listeners_count = " + listenerCount, IDebugFilter.UPDATE);
            this.startUpdateTime = System.currentTimeMillis();
        }
        final UpdateCompletedCounter updateCompletedCounter = new UpdateCompletedCounter(listenerCount, new IUpdateCompletedCallback(){

            @Override
            public void done() {
                if (BackplanePlugin.DEBUG) {
                    BackplanePlugin.debug("refresh completed", IDebugFilter.UPDATE);
                    ++ContinuousUpdator.this.updateCount;
                    ContinuousUpdator.this.totalUpdateTime += System.currentTimeMillis() - ContinuousUpdator.this.startUpdateTime;
                    if (ContinuousUpdator.this.updateCount % ContinuousUpdator.this.updatePerTrace == 0L) {
                        float totalTraceTime = (float)(System.currentTimeMillis() - ContinuousUpdator.this.lastTraceTime) / (float)ContinuousUpdator.this.updatePerTrace;
                        ContinuousUpdator.this.lastTraceTime = System.currentTimeMillis();
                        float avgUpdateTime = (float)ContinuousUpdator.this.totalUpdateTime / (float)ContinuousUpdator.this.updatePerTrace;
                        ContinuousUpdator.this.totalUpdateTime = 0L;
                        BackplanePlugin.debug("refresh " + ContinuousUpdator.this.updateCount + " completed. " + "\tAvarage refresh time = " + avgUpdateTime + "\tTotal time per update = " + totalTraceTime, IDebugFilter.UPDATE);
                    }
                }
                ContinuousUpdator.this.waitForUpdateToComplete = false;
            }
        });
        int i = 0;
        while (i < this.enabledListeners.size()) {
            final int iFinal = i;
            this.enabledListeners.get(i).update(new IUpdateCompletedCallback(){

                @Override
                public void done() {
                    if (BackplanePlugin.DEBUG) {
                        BackplanePlugin.debug("refresh start, listeners [" + iFinal + "] completed", IDebugFilter.UPDATE);
                    }
                    updateCompletedCounter.dec();
                }
            });
            ++i;
        }
    }

    public void update() {
        int i = 0;
        while (i < this.allListeners.size()) {
            this.allListeners.get(i).update(null);
            ++i;
        }
    }

    public void enableListener(IUpdateListener listener, boolean enable) {
        if (this.allListeners.indexOf(listener) == -1) {
            return;
        }
        if (enable) {
            if (!this.enabledListeners.contains(listener)) {
                this.enabledListeners.add(listener);
                this.startThread();
            }
        } else if (this.enabledListeners.contains(listener)) {
            this.enabledListeners.remove(listener);
            this.stopThread();
        }
    }
}

