/*
 * Decompiled with CFR 0.152.
 */
package com.ti.backplane.internal.update;

import com.ti.backplane.internal.update.ContinuousUpdator;
import com.ti.backplane.internal.update.IRefreshIntervalChangeListener;
import java.util.HashMap;
import java.util.HashSet;

public class UpdateManager {
    private static UpdateManager instance = new UpdateManager();
    private long refreshInterval = 100L;
    private HashMap<String, ContinuousUpdator> updators = new HashMap();
    private HashSet<IRefreshIntervalChangeListener> intervalChangeListeners = new HashSet();

    public static UpdateManager getInstance() {
        return instance;
    }

    public void setRefreshInterval(long ms) {
        this.refreshInterval = ms;
        for (IRefreshIntervalChangeListener l : this.intervalChangeListeners) {
            l.onChanged();
        }
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setContinuosRefreshEnabled(boolean enabled) {
    }

    public ContinuousUpdator getContinuousUpdator(String id) {
        ContinuousUpdator u = this.updators.get(id);
        if (u == null) {
            u = new ContinuousUpdator(this);
            this.updators.put(id, u);
        }
        return u;
    }

    void removeContinuousUpdator(String id) {
        this.updators.remove(id);
    }

    public void addRefreshIntervalChangeListener(IRefreshIntervalChangeListener l) {
        this.intervalChangeListeners.add(l);
    }

    public void removeRefreshIntervalChangeListener(IRefreshIntervalChangeListener l) {
        this.intervalChangeListeners.remove(l);
    }
}

