/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.common;

import com.ti.common.core.CoreUtils;
import com.ti.gui.composer.common.internal.ErrorReporter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;

public class GCInitData {
    private static final String WEB_APP = "gc.webApp";
    private static final String WEB_APPS = "webapps";
    private static final String WEB_APP_NAME_BASE = "webapp";
    private String webAppName;
    WebAppIsnitall webAppInstallReadOnly;
    WebAppIsnitall webAppInstallReadWrite;
    private String initFailMessage;
    private static GCInitData instance;

    public static String getFolderInPlugin(String id, String path) {
        String plguinFolder = null;
        IPath pluginFolderPath = null;
        if (Platform.inDevelopmentMode()) {
            try {
                Bundle bundle = Platform.getBundle((String)"com.ti.gui.composer.common");
                URL entry = bundle.getEntry("/");
                entry = FileLocator.toFileURL((URL)entry);
                pluginFolderPath = new Path(entry.getPath()).removeLastSegments(1);
            }
            catch (Throwable throwable) {}
        } else {
            try {
                Location location = Platform.getInstallLocation();
                URL installURL = FileLocator.toFileURL((URL)location.getURL());
                String installPath = installURL.getPath();
                pluginFolderPath = new Path(installPath).append("plugins");
            }
            catch (Throwable throwable) {}
        }
        if (pluginFolderPath != null) {
            plguinFolder = pluginFolderPath.append(id).append((IPath)new Path(path)).toOSString();
        }
        return plguinFolder;
    }

    private String getReadOnlyWebAppsFolder() {
        IPath path;
        block4: {
            String programPluginPath;
            IPath path2;
            if (Platform.inDevelopmentMode() && (path2 = new Path(programPluginPath = GCInitData.getFolderInPlugin("com.ti.backplane", "/")).removeLastSegments(1).append(WEB_APPS)).toFile().exists()) {
                return path2.toOSString();
            }
            try {
                Location location = Platform.getInstallLocation();
                URL installURL = FileLocator.toFileURL((URL)location.getURL());
                String installPath = installURL.getPath();
                path = new Path(installPath).removeLastSegments(1).append(WEB_APPS);
                if (path.toFile().exists() || path.toFile().mkdirs()) break block4;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return path.toOSString();
    }

    private String getReadWriteWebAppsFolder() {
        IPath path;
        block3: {
            try {
                path = CoreUtils.instance().getSharedTemporaryFileDir().append(".WebApp");
                if (path.toFile().exists() || path.toFile().mkdirs()) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return path.toOSString();
    }

    private GCInitData() {
        String writePath;
        String webAppDirPath = this.getReadOnlyWebAppsFolder();
        if (webAppDirPath != null) {
            String webAppPath;
            this.webAppName = System.getProperty(WEB_APP);
            if (this.webAppName != null && !this.checkFile(webAppPath = new File(webAppDirPath, this.webAppName).getAbsolutePath(), this.webAppName, false)) {
                this.webAppName = null;
            }
        }
        if (webAppDirPath != null) {
            String name = WEB_APP_NAME_BASE + new Integer(0);
            this.webAppInstallReadOnly = new WebAppIsnitall(name, webAppDirPath);
        }
        if ((writePath = this.getReadWriteWebAppsFolder()) != null) {
            String name = WEB_APP_NAME_BASE + new Integer(1);
            this.webAppInstallReadWrite = new WebAppIsnitall(name, writePath);
        }
    }

    public static synchronized GCInitData getInstance() {
        if (instance == null) {
            instance = new GCInitData();
        }
        return instance;
    }

    private boolean checkFile(String propValue, String propName, boolean file) {
        if (propValue == null || propValue.length() == 0) {
            ErrorReporter.report(String.valueOf(propName) + " not specified.");
            return false;
        }
        File f = new File(propValue);
        if (!f.exists()) {
            ErrorReporter.report(String.valueOf(propValue) + " does not exits.");
            return false;
        }
        if (file && !f.isFile()) {
            ErrorReporter.report(String.valueOf(propValue) + " is not a file.");
            return false;
        }
        if (!file && !f.isDirectory()) {
            ErrorReporter.report(String.valueOf(propValue) + " is not a folder.");
            return false;
        }
        return true;
    }

    public WebAppIsnitall getReadOnlyWebAppInstall() {
        return this.webAppInstallReadOnly;
    }

    public WebAppIsnitall getReadWriteWebAppInstall() {
        return this.webAppInstallReadWrite;
    }

    public WebAppIsnitall[] getWebAppInstalls() {
        ArrayList<WebAppIsnitall> list = new ArrayList<WebAppIsnitall>();
        if (this.webAppInstallReadOnly != null) {
            list.add(this.webAppInstallReadOnly);
        }
        if (this.webAppInstallReadWrite != null) {
            list.add(this.webAppInstallReadWrite);
        }
        return list.toArray(new WebAppIsnitall[0]);
    }

    public String getWebAppName() {
        return this.webAppName;
    }

    public String getWebAppFolder() {
        String appsFolder = this.getReadOnlyWebAppsFolder();
        String appName = this.getWebAppName();
        if (appsFolder != null && appName != null) {
            String appFolder = new Path(appsFolder).append(appName).toOSString();
            return appFolder;
        }
        return null;
    }

    public String initFaileMessage() {
        return this.initFailMessage;
    }

    public static class WebAppIsnitall {
        private String name;
        private String folder;

        WebAppIsnitall(String name, String folder) {
            this.name = name;
            this.folder = folder;
        }

        public String getName() {
            return this.name;
        }

        public String getFolder() {
            return this.folder;
        }
    }
}

