/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.common.internal;

import com.ti.backplane.bind.IStatus;
import com.ti.backplane.internal.bind.IBackplaneFileOperations;
import com.ti.gui.composer.common.internal.ServerFileOperations;
import com.ti.gui.composer.webserver.adapter.internal.IClientInfo;
import org.eclipse.core.runtime.Path;

public class BackplaneFileOperations
implements IBackplaneFileOperations {
    ServerFileOperations sfo;
    IClientInfo clientInfo;

    BackplaneFileOperations(ServerFileOperations sfo, IClientInfo clientInfo) {
        this.sfo = sfo;
        this.clientInfo = clientInfo;
    }

    public String getLocalPath(String serverPath, int storageType) {
        if (this.sfo.getFolder(storageType) == null) {
            return null;
        }
        return new Path(this.sfo.getFolder(storageType)).append(serverPath).toOSString();
    }

    public String createNewFile(String localFile, int storageType, IStatus[] status) {
        return this.sfo.generateRandonNonExistent(localFile, storageType);
    }

    public boolean isLocalOperationAllowed() {
        if (this.clientInfo == null) {
            return false;
        }
        return this.clientInfo.isLocalAddress();
    }

    public boolean ensureQuota(int storageType, long bytesRequested) {
        if (this.sfo.getFolder(storageType) == null) {
            return false;
        }
        return this.sfo.ensureQuota(storageType, bytesRequested);
    }
}

