/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.common.internal;

import com.ti.gui.composer.common.internal.ErrorReporter;
import com.ti.gui.composer.common.internal.GCAppStartupReturnInfo;
import com.ti.gui.composer.common.internal.GCLibData;
import com.ti.gui.composer.common.internal.GCResourceMapperReturnInfo;
import com.ti.gui.composer.common.internal.GCUtils;
import com.ti.gui.composer.common.internal.WebBindingRegistry;
import com.ti.gui.composer.webserver.adapter.IRequestMonitor;
import com.ti.gui.composer.webserver.adapter.IResourceMapperServlet;
import com.ti.gui.composer.webserver.adapter.internal.IBindingRegistry;
import com.ti.gui.composer.webserver.adapter.internal.IStartupInfo;
import com.ti.gui.composer.webserver.internal.GuiComposerWebServer;
import com.ti.gui.composer.webserver.internal.IResourceMapper;
import com.ti.gui.composer.webserver.internal.StartupInfo;
import com.ti.gui.composer.webserver.internal.WebAppInfo;
import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.Path;

public class GCServerInfo {
    private static final String WEB_APP_PORT = "gc.webAppPort";
    private static int PORT_DEFAULT = 7272;
    private static GCServerInfo instance = null;
    private int port;
    private boolean appWebServerStarted = false;
    private String appWebServerFalure = null;
    private HashMap<String, Long> appIndex = new HashMap();

    public static synchronized GCServerInfo getInstance() {
        if (instance == null) {
            instance = new GCServerInfo();
        }
        return instance;
    }

    private GCServerInfo() {
        this.initPort();
    }

    public String getContextName() {
        return "gc";
    }

    public int getPort() {
        return this.port;
    }

    public boolean hasPort() {
        return this.port != -1;
    }

    private void initPort() {
        boolean portSpecified;
        int firstPort = PORT_DEFAULT;
        String portName = System.getProperty(WEB_APP_PORT);
        boolean bl = portSpecified = portName != null;
        if (portSpecified) {
            try {
                this.port = new Integer(portName);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorReporter.report("gc.webAppPort is not an integer.");
                portSpecified = false;
            }
        }
        if (!portSpecified) {
            this.port = GCUtils.findFreePort(firstPort, firstPort + 200, null);
        }
    }

    public IStartupInfo getStartupInfo() {
        return new StartupInfo(this.getPort(), this.getContextName());
    }

    public synchronized void addResourceMapper(final IResourceMapperServlet resourceMapper, final IRequestMonitor monitor) {
        this.startAppServer(new IRequestMonitor(){

            public void done(Object result) {
                GCResourceMapperReturnInfo returnInfo = new GCResourceMapperReturnInfo(resourceMapper);
                GuiComposerWebServer.getInstance().addResourceMapper((IResourceMapper)returnInfo);
                monitor.done((Object)returnInfo);
            }

            public void failed(String errorMsg) {
                monitor.failed(errorMsg);
            }
        });
    }

    public synchronized void removeResourceMapper(GCResourceMapperReturnInfo resourceMapper) {
        GuiComposerWebServer.getInstance().removeResourceMapper((IResourceMapper)resourceMapper);
    }

    public synchronized void addFolder(String folder, String context, boolean autoIncrement, final IRequestMonitor monitor) {
        Path userPath = new Path(folder);
        File file = new File(userPath.toOSString());
        if (!file.exists()) {
            monitor.failed("File " + folder + " does not exist.");
            return;
        }
        int numSegments = userPath.segmentCount();
        boolean isFolder = file.isDirectory();
        if (isFolder && numSegments <= 1 || !isFolder && numSegments <= 2) {
            monitor.failed("Cannot open a top level folder. It needs to be at least two levels.");
            return;
        }
        String appPath = null;
        String appName = null;
        if (isFolder) {
            appPath = userPath.removeLastSegments(1).toOSString();
            appName = userPath.segment(numSegments - 1);
        } else {
            appPath = userPath.removeLastSegments(2).toOSString();
            appName = String.valueOf(userPath.segment(numSegments - 2)) + "/" + userPath.segment(numSegments - 1);
        }
        String appSuffix = "";
        if (autoIncrement) {
            Long id = this.appIndex.remove(context);
            id = id != null ? id + 1L : 0L;
            this.appIndex.put(context, id);
            appSuffix = id.toString();
        }
        final String finalContext = String.valueOf(context) + appSuffix;
        final String finlaFolder = appPath;
        final String finalApp = appName;
        this.startAppServer(new IRequestMonitor(){

            public void done(Object result) {
                WebAppInfo webApp = new WebAppInfo(finlaFolder, finalContext);
                GuiComposerWebServer.getInstance().addApp(webApp);
                int port = GCServerInfo.getInstance().getPort();
                String uri = "http://127.0.0.1:" + port + "/gc/" + finalContext + "/" + finalApp;
                GCAppStartupReturnInfo returnInfo = new GCAppStartupReturnInfo(webApp, uri);
                monitor.done((Object)returnInfo);
            }

            public void failed(String errorMsg) {
                monitor.failed(errorMsg);
            }
        });
    }

    public synchronized void removeFolder(GCAppStartupReturnInfo appStartupInfo) {
        GuiComposerWebServer.getInstance().removeApp(appStartupInfo.getWebAppInfo());
    }

    public synchronized void startAppServer(final IRequestMonitor monitor) {
        if (this.appWebServerStarted) {
            if (this.appWebServerFalure != null) {
                monitor.failed(this.appWebServerFalure);
            } else {
                monitor.done(null);
            }
            return;
        }
        this.appWebServerStarted = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!GCServerInfo.getInstance().hasPort()) {
                        monitor.failed("There is no available port.");
                        return;
                    }
                    WebBindingRegistry webBindingRegistry = new WebBindingRegistry();
                    GuiComposerWebServer.getInstance().start(GCServerInfo.getInstance().getStartupInfo(), null, new GCLibData().getLibInfo(), (IBindingRegistry)webBindingRegistry);
                }
                catch (Exception e) {
                    GCServerInfo.this.appWebServerFalure = e.getMessage();
                    monitor.failed(GCServerInfo.this.appWebServerFalure);
                }
                monitor.done(null);
            }
        }).start();
    }
}

