/*
 * Decompiled with CFR 0.152.
 */
package com.ti.gui.composer.common.internal;

import com.ti.backplane.bind.IBackplane;
import com.ti.backplane.bind.IBind;
import com.ti.backplane.bind.IBindFactory;
import com.ti.backplane.internal.bind.Backplane;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

class RegistryBasedDataModelContribution
implements IBindFactory {
    private IConfigurationElement registryEntry;
    private IBindFactory bindFactory = null;
    private String modelName;
    private IBackplane backplane;
    private static final String DEFAULT_MODEL = "pm";

    public RegistryBasedDataModelContribution(IConfigurationElement registryEntry) {
        this.registryEntry = registryEntry;
    }

    public IBind getBinding(String uri) {
        if (this.bindFactory == null && this.registryEntry != null) {
            try {
                this.bindFactory = (IBindFactory)this.registryEntry.createExecutableExtension("class");
            }
            catch (CoreException coreException) {}
            this.registryEntry = null;
            if (this.bindFactory != null && this.backplane != null) {
                this.bindFactory.init(this.backplane, this.modelName);
            }
        }
        return this.bindFactory == null ? null : this.bindFactory.getBinding(uri);
    }

    public void dispose() {
        if (this.bindFactory != null) {
            this.bindFactory.dispose();
        }
        this.bindFactory = null;
    }

    public void init(IBackplane backplane, String name) {
        this.modelName = name;
        this.backplane = backplane;
        if (this.bindFactory != null) {
            this.bindFactory.init(backplane, name);
        }
    }

    public IBackplane getBackplane() {
        return this.backplane;
    }

    public String getName() {
        return this.modelName;
    }

    static void addDataModelsFromRegistry(Backplane backplane) {
        IConfigurationElement[] datamodels = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ti.backplane.datamodel");
        if (datamodels != null) {
            boolean defaultModelRegistered = false;
            IConfigurationElement[] iConfigurationElementArray = datamodels;
            int n = datamodels.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement datamodel = iConfigurationElementArray[n2];
                String name = datamodel.getAttribute("name");
                if (name != null) {
                    backplane.addModel(name, (IBindFactory)new RegistryBasedDataModelContribution(datamodel));
                    if (name.equals(DEFAULT_MODEL)) {
                        defaultModelRegistered = true;
                    }
                }
                ++n2;
            }
            if (defaultModelRegistered) {
                backplane.setDefaultModel(DEFAULT_MODEL);
            }
        }
    }
}

